"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _DropDown = _interopRequireDefault(require("../DropDown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class RadioTableSpi extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      selectedIdx: props.table.defaultSelectedIdx
    };
  }

  render() {
    return _react.default.createElement(_DropDown.default, {
      toggle: "caret",
      actions: this.props.table.body.map((_, idx) => ({
        label: (0, _core.radioTableCellToString)(_.cells[_.nameIdx || 0]),
        isSelected: this.state.selectedIdx === idx,
        handler: () => (0, _core.pexecInCurrentTab)(_.onSelect)
      })),
      position: "left"
    });
  }

}

exports.default = RadioTableSpi;