import { Abortable, Arguments, Suspendable, Table, Watchable, Watcher, WatchPusher } from '@kui-shell/core';
import { Group } from './group';
import URLFormatter from './url';
import { FinalState } from '../../../lib/model/states';
import { KubeOptions } from '../../kubectl/options';
export declare abstract class DirectWatcher implements Watcher, Abortable, Suspendable {
    /** The table push API */
    protected pusher: WatchPusher;
    /** The current stream jobs. These will be aborted/flow-controlled as directed by the associated view. */
    protected jobs: (Abortable & Suspendable)[];
    abstract init(pusher: WatchPusher): void;
    /** This will be called by the view when it wants the underlying streamer to resume flowing updates */
    xon(): void;
    /** This will be called by the view when it wants the underlying streamer to stop flowing updates */
    xoff(): void;
    /** This will be called by the view when it wants the underlying streamer to die */
    abort(): void;
    /** This will be called by the streamer when the underlying job has exited */
    onExit(exitCode: number): void;
    /** This will be called by the streamer when it is ready to start flowing data. */
    onReady(): void;
}
/**
 * This class provides an implementation of a Watcher extension of a
 * Kui Table. It establishes a stream to the apiServer, and hooks the emitted stream of WatchUpdate events into the WatchPusher API of the table: i.e. the this.pusher.offline(), update(), header(), and footer() calls.
 *
 */
export declare class SingleKindDirectWatcher extends DirectWatcher implements Abortable, Watcher {
    private readonly drilldownCommand;
    private readonly args;
    private readonly kind;
    private readonly resourceVersion;
    private readonly formatUrl;
    private readonly group;
    private readonly finalState?;
    private nNotReady?;
    private readonly monitorEvents;
    private readonly needsStatusColumn;
    /** Debouncer: the apiServer may send us DELETED or ADDED events multiple times for a given resource :( */
    private readonly readyDebouncer;
    private alreadySentHeaders;
    /** We only seem to get these once, so we need to remember them */
    private bodyColumnDefinitions;
    private footerColumnDefinitions;
    constructor(drilldownCommand: string, args: Pick<Arguments<KubeOptions>, 'REPL' | 'execOptions' | 'parsedOptions'>, kind: string, resourceVersion: Table['resourceVersion'], formatUrl: URLFormatter, group: Group, finalState?: FinalState, initialRowKeys?: {
        rowKey: string;
        isReady: boolean;
    }[], nNotReady?: number, // number of resources to wait on
    monitorEvents?: boolean, needsStatusColumn?: boolean);
    /** This will be called by the view when it is ready to accept push updates */
    init(pusher: WatchPusher): Promise<void>;
    private isCustomColumns;
    /** Initialize the streamer for main body updates; i.e. for the rows of the table */
    private initBodyUpdates;
    private formatEventUrl;
    private lastFooterEvents;
    private filterFooterRows;
    /** Format a MetaTable of events into a string[] */
    private formatFooter;
    /** We pre-process the columnDefinitions for the events, to pick out the column indices of interest. */
    private initFooterColumnDefinitions;
    /** This will be called by the event streamer when it has new data */
    private onEventData;
    /** Initialize the streamer for table footer updates */
    private initFooterUpdates;
    /** This is the stream management bits for the body */
    private mgmt;
    /** The streamer is almost ready. We give it back a stream to push data to */
    onInitForBodyUpdates(job: Abortable & Suspendable): any;
    /** This will be called whenever the streamer has data for us. */
    private onData;
    /**
     * If we were asked to watch for resources reaching a given
     * `this.finalState`, then check the resource represented by the
     * given Row against the desired final state.
     *
     */
    private checkIfReady;
}
/**
 * If possible, turn a table into a Table & Watchable. If the given
 * `table` does not have a `resourceVersion` attribute, this mapping
 * will not be possible.
 *
 */
export default function makeWatchable(drilldownCommand: string, args: Pick<Arguments<KubeOptions>, 'REPL' | 'execOptions' | 'parsedOptions'>, kind: string, group: Group, table: Table, formatUrl: URLFormatter, finalState?: FinalState, initialRowKeys?: {
    rowKey: string;
    isReady: boolean;
}[], nNotReady?: number, monitorEvents?: boolean, needsStatusColumn?: boolean): Promise<Table | (Table & Watchable)>;
