"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchDelete = exports.deleteResource = exports.deleteSavedSearch = void 0;

var _HTTPClient = _interopRequireDefault(require("./HTTPClient"));

var _lodash = _interopRequireDefault(require("lodash"));

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _searchQueries = require("../definitions/search-queries");

var _search = require("./search");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

if (!window || !window.navigator || !window.navigator.userAgent) {
  Object.defineProperty(window, 'navigator', {
    value: {
      userAgent: 'node'
    },
    writable: true
  });
  Object.defineProperty(document, 'getElementById', {
    value: val => document.querySelector('#' + val),
    writable: true
  });
}

const deletedResources = [];

const deleteSavedSearch = args => new Promise(resolve => {
  if (args.argv.length === 1) {
    resolve('ERROR: Received wrong number of parameters.\nUSAGE: search -delete="save" <saved-search-name>');
  }

  const name = args.command.replace('search -delete="save" ', '');
  let warningToDelete = true;
  (0, _HTTPClient.default)('post', 'search', _searchQueries.SAVED_SEARCH_QUERY).then(res => {
    res.data.items.forEach(record => {
      if (record.name === name) {
        warningToDelete = false;
      }
    });

    if (warningToDelete) {
      res['warning'] = (0, _i18n.default)('modal.save.warning', [name]);
      resolve(res['warning']);
    } else {
      (0, _HTTPClient.default)('post', 'search', (0, _searchQueries.DELETE_QUERY)(name)).then(resp => {
        if (resp.data.deleteSearch) {
          resolve((0, _i18n.default)('modal.deleted.save.success', [name]));
        } else {
          resolve(resp.errors[0]);
        }
      }).catch(() => {
        resolve((0, _search.renderSearchAvailable)());
      });
    }
  }).catch(() => {
    resolve((0, _search.renderSearchAvailable)());
  });
});

exports.deleteSavedSearch = deleteSavedSearch;

const deleteResource = args => new Promise(resolve => {
  if (args.argv.length !== 7) {
    resolve('ERROR: Received wrong number of parameters.\nUSAGE: search -delete="resource" <resource-name> <resource-namespace> <resource-kind> <resource-cluster> <resource-apiVersion>');
  }

  (0, _HTTPClient.default)('post', 'console', (0, _searchQueries.DELETE_RESOURCE)(args.argv[2], args.argv[3], args.argv[4], args.argv[5], args.argv[6])).then(res => {
    const data = _lodash.default.get(res, 'data', '');

    if (data.deleteResource && !deletedResources.includes(args.argv[2])) {
      deletedResources.push(args.argv[2]);
      resolve(res.errors ? res.errors[0] : (0, _i18n.default)('modal.deleted.resource', [args.argv[2]]));
    } else {
      resolve((0, _i18n.default)('modal.delete.warning', [args.argv[2], args.argv[4]]));
    }
  }).catch(err => {
    resolve((0, _search.renderSearchAvailable)());
  });
});

exports.deleteResource = deleteResource;

const searchDelete = args => new Promise(resolve => {
  switch (args.argv[1]) {
    case '-delete="save"':
      resolve(deleteSavedSearch(args));
      break;

    case '-delete="resource"':
      resolve(deleteResource(args));
      break;

    default:
      resolve((0, _i18n.default)('delete.command.unknown.value'));
  }
});

exports.searchDelete = searchDelete;