import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["align", "children", "className", "disabled", "size"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';
import PropTypes from 'prop-types';
import React from 'react';

function Accordion(_ref) {
  var _cx;

  var align = _ref.align,
      children = _ref.children,
      customClassName = _ref.className,
      disabled = _ref.disabled,
      size = _ref.size,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var className = cx("".concat(prefix, "--accordion"), customClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--accordion--").concat(align), align), _defineProperty(_cx, "".concat(prefix, "--accordion--").concat(size), size), _cx));
  return /*#__PURE__*/React.createElement("ul", _extends({
    className: className
  }, rest), disabled ? React.Children.toArray(children).map(function (child) {
    return /*#__PURE__*/React.cloneElement(child, {
      disabled: disabled
    });
  }) : children);
}

Accordion.defaultProps = {
  align: 'end'
};
Accordion.propTypes = {
  /**
   * Specify the alignment of the accordion heading title and chevron.
   */
  align: PropTypes.oneOf(['start', 'end']),

  /**
   * Pass in the children that will be rendered within the Accordion
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether an individual AccordionItem should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify the size of the Accordion. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl'])
};
export default Accordion;