import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "size"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
import { AriaLabelPropType } from '../../prop-types/AriaPropTypes';
var prefix = settings.prefix;

var TableToolbar = function TableToolbar(_ref) {
  var _cx;

  var children = _ref.children,
      size = _ref.size,
      rest = _objectWithoutProperties(_ref, _excluded);

  var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--table-toolbar"), true), _defineProperty(_cx, "".concat(prefix, "--table-toolbar--").concat(size), size), _cx));
  return /*#__PURE__*/React.createElement("section", _extends({}, rest, {
    className: className
  }), children);
};

TableToolbar.propTypes = _objectSpread(_objectSpread({}, AriaLabelPropType), {}, {
  /**
   * Pass in the children that will be rendered inside the TableToolbar
   */
  children: PropTypes.node,

  /**
   * `normal` Change the row height of table
   * V11: remove small, normal
   */
  size: PropTypes.oneOf(['small', 'sm', 'normal', 'lg'])
});
TableToolbar.defaultProps = {
  'aria-label': 'data table toolbar'
};
export default TableToolbar;