import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["listBoxMenuIconTranslationIds"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, object, select, text } from '@storybook/addon-knobs';
import Dropdown from '../Dropdown';
import DropdownSkeleton from './Dropdown.Skeleton';
import mdx from './Dropdown.mdx';
import { ChartBubble16, ChartColumnFloating16, ChartVennDiagram16 } from '@carbon/icons-react';
var items = [{
  id: 'option-0',
  text: 'Lorem, ipsum dolor sit amet consectetur adipisicing elit.'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3 - a disabled item',
  disabled: true
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};
var types = {
  Default: 'default',
  Inline: 'inline'
};

var props = function props() {
  return {
    id: text('Dropdown ID (id)', 'carbon-dropdown-example'),
    size: select('Field size (size)', sizes, undefined) || undefined,
    direction: select('Dropdown direction (direction)', directions, 'bottom'),
    label: text('Label (label)', 'Dropdown menu options'),
    ariaLabel: text('Aria Label (ariaLabel)', 'Dropdown'),
    disabled: boolean('Disabled (disabled)', false),
    light: boolean('Light variant (light)', false),
    titleText: text('Title (titleText)', 'Dropdown label'),
    hideLabel: boolean('No title text shown (hideLabel)', false),
    helperText: text('Helper text (helperText)', 'This is some helper text.'),
    invalid: boolean('Show form validation UI (invalid)', false),
    invalidText: text('Form validation UI content (invalidText)', 'A valid value is required'),
    type: select('Type (type)', types, 'default'),
    warn: boolean('Show warning state (warn)', false),
    warnText: text('Warning state text (warnText)', 'This mode may perform worse on older machines'),
    listBoxMenuIconTranslationIds: object('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu'
    })
  };
};

export default {
  title: 'Components/Dropdown',
  decorators: [withKnobs],
  parameters: {
    component: Dropdown,
    subcomponents: {
      DropdownSkeleton: DropdownSkeleton
    },
    docs: {
      page: mdx
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: action('onChange')
  }));
};
export var RenderSelectedItem = function RenderSelectedItem() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "Dropdown label",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: [{
      id: 'option-0',
      icon: ChartColumnFloating16,
      text: 'Column Chart'
    }, {
      id: 'option-1',
      icon: ChartBubble16,
      text: 'Bubble Chart'
    }, {
      id: 'option-2',
      icon: ChartVennDiagram16,
      text: 'Venn Diagram'
    }],
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    itemToElement: function itemToElement(item) {
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(item.icon), /*#__PURE__*/React.createElement("span", {
        style: {
          paddingLeft: '1rem',
          paddingBottom: '1rem'
        }
      }, item.text));
    },
    renderSelectedItem: function renderSelectedItem(item) {
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(item.icon), /*#__PURE__*/React.createElement("span", {
        style: {
          paddingLeft: '1rem',
          paddingBottom: '1rem'
        }
      }, item.text));
    },
    onChange: action('onChange')
  }));
};
export var Inline = function Inline() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 600
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "inline",
    titleText: "Inline dropdown label",
    label: "Dropdown menu options",
    type: "inline",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    onChange: action('onChange')
  }));
};
export var Playground = function Playground() {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      dropdownProps = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(Dropdown, _extends({}, dropdownProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    }
  })));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(DropdownSkeleton, null));
};