/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { settings } from 'carbon-components';
import { default as FileUploader, FileUploaderButton, FileUploaderDropContainer, FileUploaderItem, FileUploaderSkeleton } from '../';
import mdx from './FileUploader.mdx';
import './FileUploader-story.scss';
var prefix = settings.prefix;
var filenameStatuses = ['edit', 'complete', 'uploading'];
export default {
  title: 'Components/FileUploader',
  parameters: {
    component: FileUploader,
    docs: {
      page: mdx
    },
    subcomponents: {
      FileUploaderButton: FileUploaderButton,
      FileUploaderSkeleton: FileUploaderSkeleton,
      FileUploaderItem: FileUploaderItem,
      FileUploaderDropContainer: FileUploaderDropContainer
    }
  }
};
export var _FileUploader = function _FileUploader(args) {
  return /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--file__container")
  }, /*#__PURE__*/React.createElement(FileUploader, args));
};
_FileUploader.args = {
  labelTitle: 'Upload files',
  labelDescription: 'Max file size is 500mb. Only .jpg files are supported.',
  buttonLabel: 'Add file',
  buttonKind: 'primary',
  size: 'default',
  filenameStatus: 'edit',
  accept: ['.jpg', '.png'],
  name: '',
  multiple: true,
  iconDescription: 'Clear file'
};
_FileUploader.argTypes = {
  onChange: {
    action: 'onChange'
  },
  onClick: {
    action: 'onClick'
  },
  onDelete: {
    action: 'onDelete'
  },
  buttonKind: {
    control: {
      type: 'select'
    },
    options: ['primary', 'secondary', 'danger', 'ghost', 'danger--primary', 'tertiary']
  },
  filenameStatus: {
    control: {
      type: 'select'
    },
    options: filenameStatuses
  },
  size: {
    control: {
      type: 'select'
    },
    options: ['field', 'small', 'default', 'sm', 'md', 'lg']
  }
};
export var _FileUploaderItem = function _FileUploaderItem(args) {
  return /*#__PURE__*/React.createElement(FileUploaderItem, args);
};
_FileUploaderItem.args = {
  name: 'README.md',
  status: 'edit',
  iconDescription: 'Clear file',
  invalid: false,
  errorSubject: 'File size exceeds limit',
  errorBody: '500kb max file size. Select a new file and try again.'
};
_FileUploaderItem.argTypes = {
  onDelete: {
    action: 'onDelete'
  },
  status: {
    control: {
      type: 'select'
    },
    options: filenameStatuses
  }
};
export var _FileUploaderDropContainer = function _FileUploaderDropContainer(args) {
  return /*#__PURE__*/React.createElement(FileUploaderDropContainer, args);
};
_FileUploaderDropContainer.args = {
  labelText: 'Drag and drop files here or click to upload',
  name: '',
  multiple: true,
  accept: ['image/jpeg', 'image/png'],
  disabled: false,
  role: '',
  tabIndex: 0
};
_FileUploaderDropContainer.argTypes = {
  onChange: {
    action: 'onChange'
  }
};
export var DragAndDropUploadContainerExampleApplication = function DragAndDropUploadContainerExampleApplication(args) {
  return require('./stories/drop-container').default(args);
};
DragAndDropUploadContainerExampleApplication.args = {
  labelText: 'Drag and drop files here or click to upload',
  name: '',
  multiple: true,
  accept: ['image/jpeg', 'image/png'],
  disabled: false,
  role: '',
  tabIndex: 0
};
DragAndDropUploadContainerExampleApplication.argTypes = {
  onChange: {
    action: 'onChange'
  }
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '500px'
    }
  }, /*#__PURE__*/React.createElement(FileUploaderSkeleton, null));
};