import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
var _excluded = ["children", "isActive", "isHighlighted", "title"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React, { useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

function useIsTruncated(ref) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isTruncated = _useState2[0],
      setIsTruncated = _useState2[1];

  useEffect(function () {
    var _ref$current = ref.current,
        offsetWidth = _ref$current.offsetWidth,
        scrollWidth = _ref$current.scrollWidth;
    setIsTruncated(offsetWidth < scrollWidth);
  }, [ref, setIsTruncated]);
  return isTruncated;
}
/**
 * `ListBoxMenuItem` is a helper component for managing the container class
 * name, alongside any classes for any corresponding states, for a generic list
 * box menu item.
 */


var ListBoxMenuItem = /*#__PURE__*/React.forwardRef(function ListBoxMenuItem(_ref, forwardedRef) {
  var _cx;

  var children = _ref.children,
      isActive = _ref.isActive,
      isHighlighted = _ref.isHighlighted,
      title = _ref.title,
      rest = _objectWithoutProperties(_ref, _excluded);

  var ref = useRef(null);
  var isTruncated = useIsTruncated((forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref);
  var className = cx("".concat(prefix, "--list-box__menu-item"), (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--list-box__menu-item--active"), isActive), _defineProperty(_cx, "".concat(prefix, "--list-box__menu-item--highlighted"), isHighlighted), _cx));
  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    className: className,
    title: isTruncated ? title : undefined
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--list-box__menu-item__option"),
    ref: (forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref
  }, children));
});
ListBoxMenuItem.displayName = 'ListBoxMenuItem';
ListBoxMenuItem.propTypes = {
  /**
   * Specify any children nodes that should be rendered inside of the ListBox
   * Menu Item
   */
  children: PropTypes.node,

  /**
   * Specify whether the current menu item is "active".
   */
  isActive: PropTypes.bool.isRequired,

  /**
   * Specify whether the current menu item is "highlighted".
   */
  isHighlighted: PropTypes.bool.isRequired,

  /**
   * Provide an optional tooltip for the ListBoxMenuItem
   */
  title: PropTypes.string
};
ListBoxMenuItem.defaultProps = {
  isActive: false,
  isHighlighted: false
};
export default ListBoxMenuItem;