import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, select, text } from '@storybook/addon-knobs';
import { ToastNotification, InlineNotification, NotificationActionButton } from '../Notification';
import mdx from './Notification.mdx';
var kinds = {
  'Error (error)': 'error',
  'Info (info)': 'info',
  'Info square (info-square)': 'info-square',
  'Success (success)': 'success',
  'Warning (warning)': 'warning',
  'Warning (warning-alt)': 'warning-alt'
};

var notificationProps = function notificationProps() {
  return {
    kind: select('The notification kind (kind)', kinds, 'info'),
    lowContrast: boolean('Use low contrast variant (lowContrast)', false),
    role: text('ARIA role (role)', 'alert'),
    title: text('Title (title)', 'Notification title'),
    subtitle: text('Subtitle (subtitle)', 'Subtitle text goes here.'),
    iconDescription: text('Icon description (iconDescription)', 'describes the close button'),
    statusIconDescription: text('Status icon description (statusIconDescription)', 'describes the status icon'),
    hideCloseButton: boolean('Hide close button (hideCloseButton)', false),
    onClose: action('onClose'),
    onCloseButtonClick: action('onCloseButtonClick')
  };
};

var toastNotificationProps = function toastNotificationProps() {
  return _objectSpread(_objectSpread({}, notificationProps()), {}, {
    timeout: number('Duration in milliseconds to display notification (timeout)', 0)
  });
};

export default {
  title: 'Components/Notifications',
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    },
    subcomponents: {
      ToastNotification: ToastNotification,
      InlineNotification: InlineNotification
    }
  }
};
export var Toast = function Toast() {
  return /*#__PURE__*/React.createElement(ToastNotification, _extends({}, toastNotificationProps(), {
    caption: text('Caption (caption)', '00:00:00 AM'),
    style: {
      marginBottom: '.5rem'
    }
  }));
};
export var Inline = function Inline() {
  return /*#__PURE__*/React.createElement(InlineNotification, _extends({}, notificationProps(), {
    actions: /*#__PURE__*/React.createElement(NotificationActionButton, {
      onClick: action('NotificationActionButton onClick')
    }, text('Action (NotificationActionButton > children)', 'Action'))
  }));
};
Inline.storyName = 'inline';