import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "renderIcon", "size"];

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useRef } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { OverflowMenuVertical16 } from '@carbon/icons-react';
import { useId } from '../../../internal/useId';
import Menu from '../../Menu';
import { keys, matches as keyCodeMatches } from '../../../internal/keyboard';
var prefix = settings.prefix;
var defaultSize = 'md';

function OverflowMenu(_ref) {
  var children = _ref.children,
      _ref$renderIcon = _ref.renderIcon,
      IconElement = _ref$renderIcon === void 0 ? OverflowMenuVertical16 : _ref$renderIcon,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? defaultSize : _ref$size,
      rest = _objectWithoutProperties(_ref, _excluded);

  var id = useId('overflowmenu');

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var _useState3 = useState([[0, 0], [0, 0]]),
      _useState4 = _slicedToArray(_useState3, 2),
      position = _useState4[0],
      setPosition = _useState4[1];

  var triggerRef = useRef(null);

  function openMenu() {
    if (triggerRef.current) {
      var _triggerRef$current$g = triggerRef.current.getBoundingClientRect(),
          left = _triggerRef$current$g.left,
          top = _triggerRef$current$g.top,
          right = _triggerRef$current$g.right,
          bottom = _triggerRef$current$g.bottom;

      setPosition([[left, right], [top, bottom]]);
    }

    setOpen(true);
  }

  function closeMenu() {
    setOpen(false);
  }

  function handleClick() {
    if (open) {
      closeMenu();
    } else {
      openMenu();
    }
  }

  function handleMousedown(e) {
    // prevent default for mousedown on trigger element to avoid
    // the "blur" event from firing on the menu as this would close
    // it and immediately re-open since "click" event is fired after
    // "blur" event.
    e.preventDefault();
  }

  function handleKeyPress(e) {
    if (open && keyCodeMatches(e, [keys.ArrowUp, keys.ArrowRight, keys.ArrowDown, keys.ArrowLeft])) {
      e.preventDefault();
    }
  }

  var containerClasses = classNames("".concat(prefix, "--overflow-menu__container"));
  var triggerClasses = classNames("".concat(prefix, "--overflow-menu"), _defineProperty({}, "".concat(prefix, "--overflow-menu--open"), open), size !== defaultSize && "".concat(prefix, "--overflow-menu--").concat(size));
  return /*#__PURE__*/React.createElement("div", {
    className: containerClasses,
    "aria-owns": id
  }, /*#__PURE__*/React.createElement("button", _extends({}, rest, {
    type: "button",
    "aria-haspopup": true,
    "aria-expanded": open,
    className: triggerClasses,
    onClick: handleClick,
    onMouseDown: handleMousedown,
    onKeyDown: handleKeyPress,
    ref: triggerRef
  }), /*#__PURE__*/React.createElement(IconElement, null)), /*#__PURE__*/React.createElement(Menu, {
    id: id,
    size: size,
    open: open,
    onClose: closeMenu,
    x: position[0],
    y: position[1]
  }, children));
}

OverflowMenu.propTypes = {
  /**
   * Specify the children of the OverflowMenu
   */
  children: PropTypes.node,

  /**
   * Function called to override icon rendering.
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Specify the size of the menu, from a list of available sizes.
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg'])
};
export default OverflowMenu;