import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "closeMenu", "disabled", "handleOverflowMenuItemFocus", "hasDivider", "href", "isDelete", "index", "itemText", "onClick", "onKeyDown", "requireTitle", "title", "wrapperClassName"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { match, keys } from '../../../internal/keyboard';
import { warning } from '../../../internal/warning';
import { usePrefix } from '../../../internal/usePrefix';
var OverflowMenuItem = /*#__PURE__*/React.forwardRef(function OverflowMenuItem(_ref, ref) {
  var _cx;

  var className = _ref.className,
      closeMenu = _ref.closeMenu,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      handleOverflowMenuItemFocus = _ref.handleOverflowMenuItemFocus,
      _ref$hasDivider = _ref.hasDivider,
      hasDivider = _ref$hasDivider === void 0 ? false : _ref$hasDivider,
      href = _ref.href,
      _ref$isDelete = _ref.isDelete,
      isDelete = _ref$isDelete === void 0 ? false : _ref$isDelete,
      index = _ref.index,
      _ref$itemText = _ref.itemText,
      itemText = _ref$itemText === void 0 ? 'Provide itemText' : _ref$itemText,
      _ref$onClick = _ref.onClick,
      onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
      _ref$onKeyDown = _ref.onKeyDown,
      _onKeyDown = _ref$onKeyDown === void 0 ? function () {} : _ref$onKeyDown,
      requireTitle = _ref.requireTitle,
      title = _ref.title,
      wrapperClassName = _ref.wrapperClassName,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();

  function setTabFocus(evt) {
    if (match(evt, keys.ArrowDown)) {
      handleOverflowMenuItemFocus({
        currentIndex: index,
        direction: 1
      });
    }

    if (match(evt, keys.ArrowUp)) {
      handleOverflowMenuItemFocus({
        currentIndex: index,
        direction: -1
      });
    }
  }

  function handleClick(evt) {
    onClick(evt);

    if (closeMenu) {
      closeMenu();
    }
  }

  if (process.env.NODE_ENV !== "production") {
    process.env.NODE_ENV !== "production" ? warning(closeMenu, '`<OverflowMenuItem>` detected missing `closeMenu` prop. ' + '`closeMenu` is required to let `<OverflowMenu>` close the menu upon actions on `<OverflowMenuItem>`. ' + 'Please make sure `<OverflowMenuItem>` is a direct child of `<OverflowMenu>.') : void 0;
  }

  var overflowMenuBtnClasses = cx("".concat(prefix, "--overflow-menu-options__btn"), className);
  var overflowMenuItemClasses = cx("".concat(prefix, "--overflow-menu-options__option"), (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--overflow-menu--divider"), hasDivider), _defineProperty(_cx, "".concat(prefix, "--overflow-menu-options__option--danger"), isDelete), _defineProperty(_cx, "".concat(prefix, "--overflow-menu-options__option--disabled"), disabled), _cx), wrapperClassName);
  var TagToUse = href ? 'a' : 'button';

  var OverflowMenuItemContent = function () {
    if (typeof itemText !== 'string') {
      return itemText;
    }

    return /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--overflow-menu-options__option-content")
    }, itemText);
  }();

  return /*#__PURE__*/React.createElement("li", {
    className: overflowMenuItemClasses,
    role: "none"
  }, /*#__PURE__*/React.createElement(TagToUse, _extends({
    className: overflowMenuBtnClasses,
    disabled: disabled,
    href: href,
    index: index,
    onClick: handleClick,
    onKeyDown: function onKeyDown(evt) {
      setTabFocus(evt);

      _onKeyDown(evt);
    },
    role: "menuitem",
    ref: ref,
    tabIndex: "-1",
    title: requireTitle ? title || itemText : null
  }, rest), OverflowMenuItemContent));
});
OverflowMenuItem.propTypes = {
  /**
   * The CSS class name to be placed on the button element
   */
  className: PropTypes.string,

  /**
   * A callback to tell the parent menu component that the menu should be closed.
   */
  closeMenu: PropTypes.func,

  /**
   * `true` to make this menu item disabled.
   */
  disabled: PropTypes.bool,
  handleOverflowMenuItemFocus: PropTypes.func,

  /**
   * `true` to make this menu item a divider.
   */
  hasDivider: PropTypes.bool,

  /**
   * If given, overflow item will render as a link with the given href
   */
  href: PropTypes.string,
  index: PropTypes.number,

  /**
   * `true` to make this menu item a "danger button".
   */
  isDelete: PropTypes.bool,

  /**
   * The text in the menu item.
   */
  itemText: PropTypes.node.isRequired,

  /**
   * event handlers
   */
  onBlur: PropTypes.func,
  onClick: PropTypes.func,
  onFocus: PropTypes.func,
  onKeyDown: PropTypes.func,
  onKeyUp: PropTypes.func,
  onMouseDown: PropTypes.func,
  onMouseEnter: PropTypes.func,
  onMouseLeave: PropTypes.func,
  onMouseUp: PropTypes.func,

  /**
   * `true` if this menu item has long text and requires a browser tooltip
   */
  requireTitle: PropTypes.bool,

  /**
   * Specify a title for the OverflowMenuItem
   */
  title: PropTypes.string,

  /**
   * The CSS class name to be placed on the wrapper list item element
   */
  wrapperClassName: PropTypes.string
};
export default OverflowMenuItem;