import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "labelText", "labelPosition", "innerRef", "hideLabel"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import classNames from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { warning } from '../../internal/warning';
import uid from '../../tools/uniqueId';
import { Text } from '../Text';
import { PrefixContext } from '../../internal/usePrefix';

var RadioButton = /*#__PURE__*/function (_React$Component) {
  _inherits(RadioButton, _React$Component);

  var _super = _createSuper(RadioButton);

  function RadioButton() {
    var _this;

    _classCallCheck(this, RadioButton);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "prefix", _this.context);

    _defineProperty(_assertThisInitialized(_this), "uid", _this.props.id || uid());

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
      _this.props.onChange(_this.props.value, _this.props.name, evt);
    });

    return _this;
  }

  _createClass(RadioButton, [{
    key: "render",
    value: function render() {
      var prefix = this.prefix;

      var _this$props = this.props,
          className = _this$props.className,
          labelText = _this$props.labelText,
          labelPosition = _this$props.labelPosition,
          ref = _this$props.innerRef,
          hideLabel = _this$props.hideLabel,
          other = _objectWithoutProperties(_this$props, _excluded);

      if (process.env.NODE_ENV !== "production") {
        process.env.NODE_ENV !== "production" ? warning(labelPosition !== 'top' && labelPosition !== 'bottom', '`top`/`bottom` values for `labelPosition` property in the `RadioButton` component is deprecated ' + 'and being removed in the next release of `carbon-components-react`.') : void 0;
      }

      var innerLabelClasses = classNames(_defineProperty({}, "".concat(prefix, "--visually-hidden"), hideLabel));
      var wrapperClasses = classNames(className, "".concat(prefix, "--radio-button-wrapper"), _defineProperty({}, "".concat(prefix, "--radio-button-wrapper--label-").concat(labelPosition), labelPosition !== 'right'));
      return /*#__PURE__*/React.createElement("div", {
        className: wrapperClasses
      }, /*#__PURE__*/React.createElement("input", _extends({}, other, {
        type: "radio",
        className: "".concat(prefix, "--radio-button"),
        onChange: this.handleChange,
        id: this.uid,
        ref: ref
      })), /*#__PURE__*/React.createElement("label", {
        htmlFor: this.uid,
        className: "".concat(prefix, "--radio-button__label")
      }, /*#__PURE__*/React.createElement("span", {
        className: "".concat(prefix, "--radio-button__appearance")
      }), labelText && /*#__PURE__*/React.createElement(Text, {
        className: innerLabelClasses
      }, labelText)));
    }
  }]);

  return RadioButton;
}(React.Component);

_defineProperty(RadioButton, "propTypes", {
  /**
   * Specify whether the <RadioButton> is currently checked
   */
  checked: PropTypes.bool,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: PropTypes.string,

  /**
   * Specify whether the <RadioButton> should be checked by default
   */
  defaultChecked: PropTypes.bool,

  /**
   * Specify whether the control is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Provide a unique id for the underlying `<input>` node
   */
  id: PropTypes.string,

  /**
   * Provide where label text should be placed
   * NOTE: `top`/`bottom` are deprecated
   */
  labelPosition: PropTypes.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Provide label text to be read by screen readers when interacting with the
   * control
   */
  labelText: PropTypes.node.isRequired,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: PropTypes.string,

  /**
   * Provide an optional `onChange` hook that is called each time the value of
   * the underlying `<input>` changes
   */
  onChange: PropTypes.func,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: PropTypes.func,

  /**
   * Specify the value of the <RadioButton>
   */
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired
});

_defineProperty(RadioButton, "contextType", PrefixContext);

_defineProperty(RadioButton, "defaultProps", {
  labelText: '',
  labelPosition: 'right',
  onChange: function onChange() {},
  value: ''
});

export { RadioButton };
export default (function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/React.createElement(RadioButton, _extends({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'RadioButton';
  return /*#__PURE__*/React.forwardRef(forwardRef);
})();