import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "size"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

function TagSkeleton(_ref) {
  var className = _ref.className,
      size = _ref.size,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("span", _extends({
    className: cx("".concat(prefix, "--tag"), "".concat(prefix, "--skeleton"), className, _defineProperty({}, "".concat(prefix, "--tag--").concat(size), size))
  }, rest));
}

TagSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Specify the size of the Tag. Currently supports either `sm` or
   * default sizes.
   */
  size: PropTypes.oneOf(['sm'])
};
export default TagSkeleton;