import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "disabled", "hideLabel", "id", "invalidText", "invalid", "labelText", "light", "maxLength", "onChange", "onClick", "onBlur", "pattern", "placeholder", "size", "type", "value"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../../internal/usePrefix';
import deprecate from '../../../prop-types/deprecate';
var TimePicker = /*#__PURE__*/React.forwardRef(function TimePicker(_ref, ref) {
  var _cx2, _cx3;

  var children = _ref.children,
      className = _ref.className,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      hideLabel = _ref.hideLabel,
      id = _ref.id,
      _ref$invalidText = _ref.invalidText,
      invalidText = _ref$invalidText === void 0 ? 'Invalid time format.' : _ref$invalidText,
      _ref$invalid = _ref.invalid,
      invalid = _ref$invalid === void 0 ? false : _ref$invalid,
      labelText = _ref.labelText,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      _ref$maxLength = _ref.maxLength,
      maxLength = _ref$maxLength === void 0 ? 5 : _ref$maxLength,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$onClick = _ref.onClick,
      onClick = _ref$onClick === void 0 ? function () {} : _ref$onClick,
      _ref$onBlur = _ref.onBlur,
      onBlur = _ref$onBlur === void 0 ? function () {} : _ref$onBlur,
      _ref$pattern = _ref.pattern,
      pattern = _ref$pattern === void 0 ? '(1[012]|[1-9]):[0-5][0-9](\\s)?' : _ref$pattern,
      _ref$placeholder = _ref.placeholder,
      placeholder = _ref$placeholder === void 0 ? 'hh:mm' : _ref$placeholder,
      size = _ref.size,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      value = _ref.value,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();

  var _React$useState = React.useState(value),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      isValue = _React$useState2[0],
      setValue = _React$useState2[1];

  var _React$useState3 = React.useState(value),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      prevValue = _React$useState4[0],
      setPrevValue = _React$useState4[1];

  if (value !== prevValue) {
    setValue(value);
    setPrevValue(value);
  }

  function handleOnClick(evt) {
    if (!disabled) {
      setValue(isValue);
      onClick(evt);
    }
  }

  function handleOnChange(evt) {
    if (!disabled) {
      setValue(isValue);
      onChange(evt);
    }
  }

  function handleOnBlur(evt) {
    if (!disabled) {
      setValue(isValue);
      onBlur(evt);
    }
  }

  var timePickerInputClasses = cx("".concat(prefix, "--time-picker__input-field"), "".concat(prefix, "--text-input"), [className], _defineProperty({}, "".concat(prefix, "--text-input--light"), light));
  var timePickerClasses = cx((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--time-picker"), true), _defineProperty(_cx2, "".concat(prefix, "--time-picker--light"), light), _defineProperty(_cx2, "".concat(prefix, "--time-picker--invalid"), invalid), _defineProperty(_cx2, "".concat(prefix, "--time-picker--").concat(size), size), _defineProperty(_cx2, className, className), _cx2));
  var labelClasses = cx("".concat(prefix, "--label"), (_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_cx3, "".concat(prefix, "--label--disabled"), disabled), _cx3));
  var label = labelText ? /*#__PURE__*/React.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var error = invalid ? /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form-requirement")
  }, invalidText) : null;
  return /*#__PURE__*/React.createElement("div", {
    className: cx("".concat(prefix, "--form-item"), className)
  }, label, /*#__PURE__*/React.createElement("div", {
    className: timePickerClasses
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--time-picker__input")
  }, /*#__PURE__*/React.createElement("input", _extends({
    className: timePickerInputClasses,
    "data-invalid": invalid ? invalid : undefined,
    disabled: disabled,
    id: id,
    maxLength: maxLength,
    onClick: handleOnClick,
    onChange: handleOnChange,
    onBlur: handleOnBlur,
    placeholder: placeholder,
    pattern: pattern,
    ref: ref,
    type: type,
    value: value
  }, rest))), children), error);
});
TimePicker.propTypes = {
  /**
   * Pass in the children that will be rendered next to the form control
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: PropTypes.bool,

  /**
   * Specify a custom `id` for the `<input>`
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: PropTypes.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: PropTypes.node,

  /**
   * `true` to use the light version. TODO: V12 remove this.
   */
  light: deprecate(PropTypes.bool, 'The `light` prop for `Tile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * Specify the maximum length of the time string in `<input>`
   */
  maxLength: PropTypes.number,

  /**
   * Optionally provide an `onBlur` handler that is called whenever the
   * `<input>` loses focus
   */
  onBlur: PropTypes.func,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: PropTypes.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the regular expression working as the pattern of the time string in `<input>`
   */
  pattern: PropTypes.string,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: PropTypes.string,

  /**
   * Specify the size of the Time Picker. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg']),

  /**
   * Specify the type of the `<input>`
   */
  type: PropTypes.string,

  /**
   * Specify the value of the `<input>`
   */
  value: PropTypes.string
};
export default TimePicker;