import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, text, boolean, select } from '@storybook/addon-knobs';
import Toggle from '../Toggle';
import ToggleSkeleton from '../Toggle/Toggle.Skeleton';
import { Text } from '../Text';
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined
};

var toggleProps = function toggleProps() {
  return {
    labelText: text('Label toggle input control (labelText)', 'Toggle element label'),
    className: 'some-class',
    labelA: text('Label for untoggled state (labelA)', 'Off'),
    labelB: text('Label for toggled state (labelB)', 'On'),
    disabled: boolean('Disabled (disabled)', false),
    onChange: action('onChange'),
    onToggle: action('onToggle'),
    size: select('Field size (size)', sizes, undefined) || undefined
  };
};

export default {
  title: 'Components/Toggle',
  decorators: [withKnobs],
  parameters: {
    component: Toggle,
    subcomponents: {}
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Toggle, {
    labelText: "Toggle (md)",
    size: "md",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    className: "some-class",
    id: "toggle-1"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Toggle, {
    labelText: "Toggle (sm)",
    size: "sm",
    defaultToggled: true,
    className: "some-class",
    id: "toggle-2"
  }));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Text, {
    as: "p"
  }, "Md skeleton with label"), /*#__PURE__*/React.createElement(ToggleSkeleton, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Text, {
    as: "p"
  }, "Sm skeleton with label"), /*#__PURE__*/React.createElement(ToggleSkeleton, {
    labelText: "Toggle label",
    id: "toggle-skeleton-id",
    size: "sm"
  }));
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(Toggle, _extends({
    defaultToggled: true
  }, toggleProps(), {
    className: "some-class",
    id: "toggle-3"
  }));
};
Default.storyName = 'Toggle';