import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { CARBON_SIDENAV_ITEMS } from './_utils';
import { usePrefix } from '../../internal/usePrefix';

var SideNavItems = function SideNavItems(_ref) {
  var customClassName = _ref.className,
      children = _ref.children,
      isSideNavExpanded = _ref.isSideNavExpanded;
  var prefix = usePrefix();
  var className = cx(["".concat(prefix, "--side-nav__items")], customClassName);
  var childrenWithExpandedState = React.Children.map(children, function (child) {
    if ( /*#__PURE__*/React.isValidElement(child)) {
      var _child$type;

      // avoid spreading `isSideNavExpanded` to non-Carbon UI Shell children
      return /*#__PURE__*/React.cloneElement(child, _objectSpread({}, CARBON_SIDENAV_ITEMS.includes((_child$type = child.type) === null || _child$type === void 0 ? void 0 : _child$type.displayName) ? {
        isSideNavExpanded: isSideNavExpanded
      } : {}));
    }
  });
  return /*#__PURE__*/React.createElement("ul", {
    className: className
  }, childrenWithExpandedState);
};

SideNavItems.propTypes = {
  /**
   * Provide a single icon as the child to `SideNavIcon` to render in the
   * container
   */
  children: PropTypes.node.isRequired,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: PropTypes.string,

  /**
   * Property to indicate if the side nav container is open (or not). Use to
   * keep local state and styling in step with the SideNav expansion state.
   */
  isSideNavExpanded: PropTypes.bool
};
export default SideNavItems;