"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CopyButton;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _Copy = _interopRequireDefault(require("../Copy"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["iconDescription", "className"];

function CopyButton(_ref) {
  var iconDescription = _ref.iconDescription,
      className = _ref.className,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement(_Copy.default, (0, _extends2.default)({
    className: (0, _classnames.default)(className, "".concat(prefix, "--copy-btn")),
    "aria-label": iconDescription,
    title: iconDescription
  }, other), /*#__PURE__*/_react.default.createElement(_iconsReact.Copy16, {
    className: "".concat(prefix, "--snippet__icon")
  }));
}

CopyButton.propTypes = {
  /**
   * Specify an optional className to be applied to the underlying `<button>`
   */
  className: _propTypes.default.string,

  /**
   * Specify the string that is displayed when the button is clicked and the
   * content is copied
   */
  feedback: _propTypes.default.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: _propTypes.default.number,

  /**
   * Provide a description for the icon representing the copy action that can
   * be read by screen readers
   */
  iconDescription: _propTypes.default.string,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * `<button>` is clicked
   */
  onClick: _propTypes.default.func
};
CopyButton.defaultProps = {
  iconDescription: 'Copy to clipboard',
  feedback: 'Copied!',
  feedbackTimeout: 2000,
  onClick: function onClick() {}
};