"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["range", "id", "className"];

var DatePickerSkeleton = function DatePickerSkeleton(_ref) {
  var range = _ref.range,
      id = _ref.id,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();

  var dateInput = /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--date-picker-container")
  },
  /*#__PURE__*/

  /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control */
  _react.default.createElement("label", {
    className: "".concat(prefix, "--label"),
    htmlFor: id
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--date-picker__input ").concat(prefix, "--skeleton")
  }));

  if (range) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--form-item")
    }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
      className: (0, _classnames.default)("".concat(prefix, "--date-picker"), "".concat(prefix, "--date-picker--range"), "".concat(prefix, "--skeleton"), className)
    }, rest), dateInput, dateInput));
  }

  return /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-item")
  }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: (0, _classnames.default)("".concat(prefix, "--date-picker"), "".concat(prefix, "--date-picker--short"), "".concat(prefix, "--date-picker--simple"), "".concat(prefix, "--skeleton"), className)
  }, rest), dateInput));
};

DatePickerSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Specify the id to add.
   */
  id: _propTypes.default.string,

  /**
   * Specify whether the skeleton should be of range date picker.
   */
  range: _propTypes.default.bool
};
var _default = DatePickerSkeleton;
exports.default = _default;