"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.DatePickerPlayground = exports.RangeWithCalendarWithLayer = exports.SingleWithCalendarWithLayer = exports.SimpleWithLayer = exports.RangeWithCalendar = exports.SingleWithCalendar = exports.Simple = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _ = _interopRequireWildcard(require("../"));

var _DatePickerInput = _interopRequireDefault(require("../../DatePickerInput"));

var _Layer = require("../../Layer");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
// const patterns = {
//   'Short (d{1,2}/d{4})': '\\d{1,2}/\\d{4}',
//   'Regular (d{1,2}/d{1,2}/d{4})': '\\d{1,2}/\\d{1,2}/\\d{4}',
// };
// const sizes = {
//   'Small  (sm)': 'sm',
//   'Medium (md) - default': undefined,
//   'Large  (lg)': 'lg',
// };
// const types = {
//   Simple: 'simple',
//   Single: 'single',
//   Range: 'range',
// };
var props = {
  datePicker: function datePicker() {
    return {
      dateFormat: 'm/d/Y',
      id: 'date-picker',
      light: false,
      datePickerType: 'single',
      minDate: '11/15/2020',
      maxDate: '11/01/2040',
      disable: ['07/15/2021'],
      onClose: (0, _addonActions.action)('onClose'),
      onOpen: (0, _addonActions.action)('onOpen')
    };
  },
  datePickerInput: function datePickerInput() {
    return {
      id: 'date-picker-input-id',
      className: 'some-class',
      size: undefined,
      labelText: 'Date Picker label',
      pattern: 'd{1,2}/d{4}',
      placeholder: 'mm/dd/yyyy',
      disabled: false,
      invalid: false,
      invalidText: 'A valid date is required',
      warn: false,
      warnText: 'Selected dates may cause conflicts',
      iconDescription: 'Icon description'
    };
  }
};
var _default = {
  title: 'Components/DatePicker',
  parameters: {
    component: _.default,
    subcomponents: {
      DatePickerInput: _DatePickerInput.default,
      DatePickerSkeleton: _.DatePickerSkeleton
    }
  }
};
exports.default = _default;

var Simple = function Simple() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "simple"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  }));
};

exports.Simple = Simple;

var SingleWithCalendar = function SingleWithCalendar() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "single"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  }));
};

exports.SingleWithCalendar = SingleWithCalendar;

var RangeWithCalendar = function RangeWithCalendar() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "range"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  }));
};

exports.RangeWithCalendar = RangeWithCalendar;

var SimpleWithLayer = function SimpleWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "simple"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "simple"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "simple"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  })))));
};

exports.SimpleWithLayer = SimpleWithLayer;

var SingleWithCalendarWithLayer = function SingleWithCalendarWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "single"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "single"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "single"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  })))));
};

exports.SingleWithCalendarWithLayer = SingleWithCalendarWithLayer;

var RangeWithCalendarWithLayer = function RangeWithCalendarWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "range"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "range"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    datePickerType: "range"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  })))));
};
/* eslint-disable react/prop-types */


exports.RangeWithCalendarWithLayer = RangeWithCalendarWithLayer;

var DatePickerPlayground = function DatePickerPlayground() {
  return /*#__PURE__*/_react.default.createElement(_.default, props.datePicker(), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, props.datePickerInput()), props.datePicker().datePickerType === 'range' && /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, (0, _extends2.default)({}, props.datePickerInput(), {
    id: "date-picker-input-2"
  })));
};
/* eslint-enable react/prop-types */


exports.DatePickerPlayground = DatePickerPlayground;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_.DatePickerSkeleton, {
    range: true
  });
};

exports.Skeleton = Skeleton;