"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DialogExample = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var React = _interopRequireWildcard(require("react"));

var _FocusScope = require("../FocusScope");

var _Dialog = require("../Dialog");

var _useId = require("../../internal/useId");

var _Portal = require("../Portal");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_Dialog',
  includeStories: []
};
exports.default = _default;

var Default = function Default() {
  function DemoComponent() {
    var _React$useState = React.useState(false),
        _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
        open = _React$useState2[0],
        setOpen = _React$useState2[1];

    var ref = React.useRef(null);
    return /*#__PURE__*/React.createElement("div", {
      style: {
        border: '1px solid black',
        background: 'rgba(0, 0, 0, 0.1)',
        padding: '1rem'
      }
    }, /*#__PURE__*/React.createElement("button", {
      type: "button",
      onClick: function onClick() {
        setOpen(true);
      }
    }, "Open"), open ? /*#__PURE__*/React.createElement(_FocusScope.FocusScope, null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("p", null, "Elit hic at labore culpa itaque fugiat. Consequuntur iure autem autem officiis dolores facilis nulla earum! Neque quia nemo sequi assumenda ratione officia Voluptate beatae eligendi placeat nemo laborum, ratione."), /*#__PURE__*/React.createElement(DemoComponent, null), /*#__PURE__*/React.createElement("button", {
      ref: ref,
      type: "button",
      onClick: function onClick() {
        setOpen(false);
      }
    }, "Close"))) : null);
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(DemoComponent, null), /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, "Hello"));
};

exports.Default = Default;

var DialogExample = function DialogExample() {
  function Example() {
    var _React$useState3 = React.useState(false),
        _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
        open = _React$useState4[0],
        setOpen = _React$useState4[1];

    var id = (0, _useId.useId)();
    return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
      type: "button"
    }, "First")), /*#__PURE__*/React.createElement("button", {
      type: "button",
      onClick: function onClick() {
        setOpen(true);
      }
    }, "Open"), open ? /*#__PURE__*/React.createElement(_Portal.Portal, {
      style: {
        position: 'fixed',
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        zIndex: 9999
      }
    }, /*#__PURE__*/React.createElement(FullPage, null), /*#__PURE__*/React.createElement(_Dialog.Dialog, {
      "aria-labelledby": id,
      onDismiss: function onDismiss() {
        setOpen(false);
      },
      style: {
        position: 'relative',
        zIndex: 9999,
        padding: '1rem',
        background: 'white'
      }
    }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("span", {
      id: id
    }, "Hello")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, null)), /*#__PURE__*/React.createElement("button", {
      type: "button",
      onClick: function onClick() {
        setOpen(false);
      }
    }, "Close"))) : null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
      type: "button"
    }, "Last")));
  }

  return /*#__PURE__*/React.createElement(Example, null);
};

exports.DialogExample = DialogExample;
var FullPage = /*#__PURE__*/React.forwardRef(function FullPage(props, ref) {
  return /*#__PURE__*/React.createElement("div", (0, _extends2.default)({
    ref: ref,
    style: {
      position: 'absolute',
      top: 0,
      left: 0,
      bottom: 0,
      right: 0,
      transform: 'translateZ(0)',
      background: 'rgba(0, 0, 0, 0.5)'
    }
  }, props));
});