"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _classnames3 = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _carbonComponentsReact = require("carbon-components-react");

require("../FileUploader-story.scss");

var _excluded = ["uuid", "name", "filesize", "status", "iconDescription", "invalid"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var prefix = _carbonComponents.settings.prefix; // -- copied from internal/tools/uniqueId.js

var lastId = 0;

function uid() {
  var prefix = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'id';
  lastId++;
  return "".concat(prefix).concat(lastId);
} // -- end copied


var ExampleDropContainerApp = function ExampleDropContainerApp(props) {
  var _useState = (0, _react.useState)([]),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      files = _useState2[0],
      setFiles = _useState2[1];

  var handleDrop = function handleDrop(e) {
    e.preventDefault();
  };

  var handleDragover = function handleDragover(e) {
    e.preventDefault();
  };

  (0, _react.useEffect)(function () {
    document.addEventListener('drop', handleDrop);
    document.addEventListener('dragover', handleDragover);
    return function () {
      document.removeEventListener('drop', handleDrop);
      document.removeEventListener('dragover', handleDragover);
    };
  }, []);

  var uploadFile = /*#__PURE__*/function () {
    var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(fileToUpload) {
      var updatedFile, _updatedFile, rand;

      return _regenerator.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!(fileToUpload.filesize > 512000)) {
                _context.next = 4;
                break;
              }

              updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                status: 'edit',
                iconDescription: 'Delete file',
                invalid: true,
                errorSubject: 'File size exceeds limit',
                errorBody: '500kb max file size. Select a new file and try again.'
              });
              setFiles(function (files) {
                return files.map(function (file) {
                  return file.uuid === fileToUpload.uuid ? updatedFile : file;
                });
              });
              return _context.abrupt("return");

            case 4:
              if (!fileToUpload.invalidFileType) {
                _context.next = 8;
                break;
              }

              _updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                status: 'edit',
                iconDescription: 'Delete file',
                invalid: true,
                errorSubject: 'Invalid file type',
                errorBody: "\"".concat(fileToUpload.name, "\" does not have a valid file type.")
              });
              setFiles(function (files) {
                return files.map(function (file) {
                  return file.uuid === fileToUpload.uuid ? _updatedFile : file;
                });
              });
              return _context.abrupt("return");

            case 8:
              // simulate network request time
              rand = Math.random() * 1000;
              setTimeout(function () {
                var updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                  status: 'complete',
                  iconDescription: 'Upload complete'
                });

                setFiles(function (files) {
                  return files.map(function (file) {
                    return file.uuid === fileToUpload.uuid ? updatedFile : file;
                  });
                });
              }, rand); // show x icon after 1 second

              setTimeout(function () {
                var updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                  status: 'edit',
                  iconDescription: 'Delete file'
                });

                setFiles(function (files) {
                  return files.map(function (file) {
                    return file.uuid === fileToUpload.uuid ? updatedFile : file;
                  });
                });
              }, rand + 1000);

            case 11:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function uploadFile(_x) {
      return _ref.apply(this, arguments);
    };
  }();

  var onAddFiles = (0, _react.useCallback)(function (evt, _ref2) {
    var addedFiles = _ref2.addedFiles;
    evt.stopPropagation();
    var newFiles = addedFiles.map(function (file) {
      return {
        uuid: uid(),
        name: file.name,
        filesize: file.size,
        status: 'uploading',
        iconDescription: 'Uploading',
        invalidFileType: file.invalidFileType
      };
    }); // eslint-disable-next-line react/prop-types

    if (props.multiple) {
      setFiles([].concat((0, _toConsumableArray2.default)(files), (0, _toConsumableArray2.default)(newFiles)));
      newFiles.forEach(uploadFile);
    } else if (newFiles[0]) {
      setFiles([newFiles[0]]);
      uploadFile(newFiles[0]);
    }
  }, // eslint-disable-next-line react/prop-types
  [files, props.multiple]);
  var handleFileUploaderItemClick = (0, _react.useCallback)(function (_, _ref3) {
    var clickedUuid = _ref3.uuid;
    return setFiles(files.filter(function (_ref4) {
      var uuid = _ref4.uuid;
      return clickedUuid !== uuid;
    }));
  }, [files]);
  var labelClasses = (0, _classnames3.default)("".concat(prefix, "--file--label"), (0, _defineProperty2.default)({}, "".concat(prefix, "--file--label--disabled"), props.disabled));
  var helperTextClasses = (0, _classnames3.default)("".concat(prefix, "--label-description"), (0, _defineProperty2.default)({}, "".concat(prefix, "--label-description--disabled"), props.disabled));
  return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.FormItem, null, /*#__PURE__*/_react.default.createElement("p", {
    className: labelClasses
  }, "Upload files"), /*#__PURE__*/_react.default.createElement("p", {
    className: helperTextClasses
  }, "Max file size is 500kb. Supported file types are .jpg and .png."), /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.FileUploaderDropContainer, (0, _extends2.default)({}, props, {
    onAddFiles: onAddFiles
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--file-container"),
    style: {
      width: '100%'
    }
  }, files.map(function (_ref5) {
    var uuid = _ref5.uuid,
        name = _ref5.name,
        filesize = _ref5.filesize,
        status = _ref5.status,
        iconDescription = _ref5.iconDescription,
        invalid = _ref5.invalid,
        rest = (0, _objectWithoutProperties2.default)(_ref5, _excluded);
    return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.FileUploaderItem, (0, _extends2.default)({
      key: uid(),
      uuid: uuid,
      name: name,
      filesize: filesize // eslint-disable-next-line react/prop-types
      ,
      size: props.size,
      status: status,
      iconDescription: iconDescription,
      invalid: invalid,
      onDelete: handleFileUploaderItemClick
    }, rest));
  })));
};

var _default = ExampleDropContainerApp;
exports.default = _default;