"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _carbonComponents = require("carbon-components");

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var InlineCheckbox = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(InlineCheckbox, _React$Component);

  var _super = _createSuper(InlineCheckbox);

  function InlineCheckbox() {
    var _this;

    (0, _classCallCheck2.default)(this, InlineCheckbox);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleRef", function (el) {
      _this.inputNode = el;
    });
    return _this;
  }

  (0, _createClass2.default)(InlineCheckbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.inputNode) {
        this.inputNode.indeterminate = this.props.indeterminate;
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.inputNode && prevProps.indeterminate !== this.props.indeterminate) {
        this.inputNode.indeterminate = this.props.indeterminate;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          indeterminate = _this$props.indeterminate,
          checked = _this$props.checked,
          disabled = _this$props.disabled,
          ariaLabel = _this$props.ariaLabel,
          name = _this$props.name,
          _onChange = _this$props.onChange,
          onClick = _this$props.onClick,
          onKeyDown = _this$props.onKeyDown,
          _this$props$title = _this$props.title,
          title = _this$props$title === void 0 ? undefined : _this$props$title,
          ref = _this$props.innerRef;
      var inputProps = {
        id: id,
        name: name,
        onClick: onClick,
        onChange: function onChange(evt) {
          _onChange(evt.target.checked, id, evt);
        },
        onKeyDown: onKeyDown,
        className: "".concat(prefix, "--checkbox"),
        type: 'checkbox',
        ref: (0, _mergeRefs.default)(ref, this.handleRef),
        checked: false,
        disabled: disabled
      };

      if (checked) {
        inputProps.checked = true;
      }

      if (indeterminate) {
        inputProps.checked = false;
        inputProps['aria-checked'] = 'mixed';
      }

      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("input", inputProps),
      /*#__PURE__*/

      /* eslint-disable jsx-a11y/label-has-for,jsx-a11y/label-has-associated-control,jsx-a11y/click-events-have-key-events,jsx-a11y/no-noninteractive-element-interactions */
      _react.default.createElement("label", {
        htmlFor: id,
        className: "".concat(prefix, "--checkbox-label"),
        "aria-label": ariaLabel,
        title: title,
        onClick: function onClick(evt) {
          evt.stopPropagation();
        }
      }));
    }
  }]);
  return InlineCheckbox;
}(_react.default.Component);

(0, _defineProperty2.default)(InlineCheckbox, "propTypes", {
  /**
   * Specify the label for the control
   */
  ariaLabel: _propTypes.default.string.isRequired,

  /**
   * Specify whether the underlying control is checked, or not
   */
  checked: _propTypes.default.bool.isRequired,

  /**
   * Specify whether the underlying input control should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide an `id` for the underlying input control
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify whether the control is in an indterminate state
   */
  indeterminate: _propTypes.default.bool,

  /**
   * Provide a `name` for the underlying input control
   */
  name: _propTypes.default.string.isRequired,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: _propTypes.default.func,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Provide an optional tooltip for the InlineCheckbox
   */
  title: _propTypes.default.string
});
(0, _defineProperty2.default)(InlineCheckbox, "defaultProps", {
  ariaLabel: '',
  checked: false,
  id: 'inline-checkbox',
  name: '',
  onChange: function onChange() {}
});

var _default = function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/_react.default.createElement(InlineCheckbox, (0, _extends2.default)({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'InlineCheckbox';
  return /*#__PURE__*/_react.default.forwardRef(forwardRef);
}();

exports.default = _default;