"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["children", "className"];
var prefix = _carbonComponents.settings.prefix;

var ListItem = function ListItem(_ref) {
  var children = _ref.children,
      className = _ref.className,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var classNames = (0, _classnames.default)("".concat(prefix, "--list__item"), className);
  return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
    className: classNames
  }, other), children);
};

ListItem.propTypes = {
  /**
   * Specify the content for the ListItem
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to apply to the underlying `<li>` node
   */
  className: _propTypes.default.string
};
var _default = ListItem;
exports.default = _default;