"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PassiveModal = exports.WithStateManager = exports.Playground = exports.Default = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _addonActions = require("@storybook/addon-actions");

var _Modal = _interopRequireDefault(require("./Modal"));

var _Button = _interopRequireDefault(require("../../Button"));

var _Select = _interopRequireDefault(require("../../Select"));

var _MultiSelect = _interopRequireDefault(require("../../MultiSelect"));

var _Dropdown = _interopRequireDefault(require("../../Dropdown"));

var _SelectItem = _interopRequireDefault(require("../../SelectItem"));

var _TextInput = _interopRequireDefault(require("../../TextInput"));

var _Modal2 = _interopRequireDefault(require("../Modal.mdx"));

var _excluded = ["size", "numberOfButtons", "hasScrollingContent"],
    _excluded2 = ["passiveModal"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var buttons = {
  'None (0)': '0',
  'One (1)': '1',
  'Two (2)': '2',
  'Three (3)': '3'
};
var props = {
  modal: function modal() {
    return {
      numberOfButtons: ('Number of Buttons', buttons, '2'),
      className: 'some-class',
      open: true,
      danger: false,
      alert: false,
      shouldSubmitOnEnter: false,
      hasScrollingContent: false,
      hasForm: false,
      modalHeading: 'Modal heading',
      modalLabel: 'Label',
      modalAriaLabel: 'A label to be read by screen readers on the modal root node',
      selectorPrimaryFocus: '[data-modal-primary-focus]',
      size: 'md',
      onBlur: (0, _addonActions.action)('onBlur'),
      onClick: (0, _addonActions.action)('onClick'),
      onFocus: (0, _addonActions.action)('onFocus'),
      onRequestClose: (0, _addonActions.action)('onRequestClose'),
      onRequestSubmit: (0, _addonActions.action)('onRequestSubmit'),
      onSecondarySubmit: (0, _addonActions.action)('onSecondarySubmit'),
      preventCloseOnClickOutside: true,
      primaryButtonDisabled: false,
      primaryButtonText: 'Primary button'
    };
  },
  modalFooter: function modalFooter(numberOfButtons) {
    var secondaryButtons = function secondaryButtons() {
      switch (numberOfButtons) {
        case '2':
          return {
            secondaryButtonText: 'Secondary button'
          };

        case '3':
          return {
            secondaryButtons: [{
              buttonText: 'Keep both',
              onClick: (0, _addonActions.action)('onClick')
            }, {
              buttonText: 'Rename',
              onClick: (0, _addonActions.action)('onClick')
            }]
          };

        default:
          return null;
      }
    };

    return _objectSpread({
      passiveModal: false || numberOfButtons === '0'
    }, secondaryButtons());
  }
};
var _default = {
  title: 'Components/Modal',
  parameters: {
    component: _Modal.default,
    docs: {
      page: _Modal2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Modal.default, {
    open: true,
    modalHeading: "Add a custom domain",
    modalLabel: "Account resources",
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel"
  }, /*#__PURE__*/_react.default.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_Select.default, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "us-east",
    text: "US East"
  })), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
    id: "drop",
    label: "Dropdown",
    titleText: "Dropdown",
    items: [{
      id: 'one',
      label: 'one',
      name: 'one'
    }, {
      id: 'two',
      label: 'two',
      name: 'two'
    }]
  }), /*#__PURE__*/_react.default.createElement(_MultiSelect.default, {
    id: "test",
    label: "Multiselect",
    items: [{
      id: 'downshift-1-item-0',
      text: 'Option 1'
    }, {
      id: 'downshift-1-item-1',
      text: 'Option 2'
    }],
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    }
  }));
};

exports.Default = Default;

var Playground = function Playground() {
  var _props$modal = props.modal(),
      size = _props$modal.size,
      numberOfButtons = _props$modal.numberOfButtons,
      hasScrollingContent = _props$modal.hasScrollingContent,
      modalProps = (0, _objectWithoutProperties2.default)(_props$modal, _excluded);

  var _props$modalFooter = props.modalFooter(numberOfButtons),
      passiveModal = _props$modalFooter.passiveModal,
      footerProps = (0, _objectWithoutProperties2.default)(_props$modalFooter, _excluded2);

  return /*#__PURE__*/_react.default.createElement(_Modal.default, (0, _extends2.default)({
    passiveModal: numberOfButtons === '0' || passiveModal,
    size: size || undefined,
    hasScrollingContent: hasScrollingContent,
    "aria-label": hasScrollingContent ? 'Modal content' : undefined
  }, modalProps, footerProps), /*#__PURE__*/_react.default.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    "data-modal-primary-focus": true,
    id: "text-input-1",
    labelText: "Domain name",
    placeholder: "e.g. github.com",
    style: {
      marginBottom: '1rem'
    }
  }), /*#__PURE__*/_react.default.createElement(_Select.default, {
    id: "select-1",
    defaultValue: "us-south",
    labelText: "Region"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "us-south",
    text: "US South"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "us-east",
    text: "US East"
  })), /*#__PURE__*/_react.default.createElement("br", null), hasScrollingContent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/_react.default.createElement("h3", null, "Lorem ipsum"), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' '), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean id accumsan augue. Phasellus consequat augue vitae tellus tincidunt posuere. Curabitur justo urna, consectetur vel elit iaculis, ultrices condimentum risus. Nulla facilisi. Etiam venenatis molestie tellus. Quisque consectetur non risus eu rutrum.", ' ')));
};

exports.Playground = Playground;

var WithStateManager = function WithStateManager() {
  /**
   * Simple state manager for modals.
   */
  var ModalStateManager = function ModalStateManager(_ref) {
    var LauncherContent = _ref.renderLauncher,
        ModalContent = _ref.children;

    var _useState = (0, _react.useState)(false),
        _useState2 = (0, _slicedToArray2.default)(_useState, 2),
        open = _useState2[0],
        setOpen = _useState2[1];

    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !ModalContent || typeof document === 'undefined' ? null : /*#__PURE__*/_reactDom.default.createPortal( /*#__PURE__*/_react.default.createElement(ModalContent, {
      open: open,
      setOpen: setOpen
    }), document.body), LauncherContent && /*#__PURE__*/_react.default.createElement(LauncherContent, {
      open: open,
      setOpen: setOpen
    }));
  };

  return /*#__PURE__*/_react.default.createElement(ModalStateManager, {
    renderLauncher: function renderLauncher(_ref2) {
      var setOpen = _ref2.setOpen;
      return /*#__PURE__*/_react.default.createElement(_Button.default, {
        onClick: function onClick() {
          return setOpen(true);
        }
      }, "Launch modal");
    }
  }, function (_ref3) {
    var open = _ref3.open,
        setOpen = _ref3.setOpen;
    return /*#__PURE__*/_react.default.createElement(_Modal.default, {
      modalHeading: "Add a custom domain",
      modalLabel: "Account resources",
      primaryButtonText: "Add",
      secondaryButtonText: "Cancel",
      open: open,
      onRequestClose: function onRequestClose() {
        return setOpen(false);
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      style: {
        marginBottom: '1rem'
      }
    }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host."), /*#__PURE__*/_react.default.createElement(_TextInput.default, {
      "data-modal-primary-focus": true,
      id: "text-input-1",
      labelText: "Domain name",
      placeholder: "e.g. github.com",
      style: {
        marginBottom: '1rem'
      }
    }), /*#__PURE__*/_react.default.createElement(_Select.default, {
      id: "select-1",
      defaultValue: "us-south",
      labelText: "Region"
    }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      value: "us-south",
      text: "US South"
    }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
      value: "us-east",
      text: "US East"
    })));
  });
};

exports.WithStateManager = WithStateManager;

var PassiveModal = function PassiveModal() {
  return /*#__PURE__*/_react.default.createElement(_Modal.default, {
    open: true,
    passiveModal: true,
    modalHeading: "You have been successfully signed out"
  });
};

exports.PassiveModal = PassiveModal;