"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../../internal/usePrefix");

var _useId = require("../../../internal/useId");

var _Text = require("../../Text");

var _excluded = ["className", "disabled", "hideLabel", "id", "labelPosition", "labelText", "name", "onChange", "value"];

var RadioButton = /*#__PURE__*/_react.default.forwardRef(function RadioButton(_ref, ref) {
  var className = _ref.className,
      disabled = _ref.disabled,
      hideLabel = _ref.hideLabel,
      id = _ref.id,
      _ref$labelPosition = _ref.labelPosition,
      labelPosition = _ref$labelPosition === void 0 ? 'right' : _ref$labelPosition,
      _ref$labelText = _ref.labelText,
      labelText = _ref$labelText === void 0 ? '' : _ref$labelText,
      name = _ref.name,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? '' : _ref$value,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var uid = (0, _useId.useId)('radio-button');
  var uniqueId = id || uid;

  function handleOnChange(event) {
    onChange(value, name, event);
  }

  var innerLabelClasses = (0, _classnames.default)((0, _defineProperty2.default)({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var wrapperClasses = (0, _classnames.default)(className, "".concat(prefix, "--radio-button-wrapper"), (0, _defineProperty2.default)({}, "".concat(prefix, "--radio-button-wrapper--label-").concat(labelPosition), labelPosition !== 'right'));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, rest, {
    type: "radio",
    className: "".concat(prefix, "--radio-button"),
    onChange: handleOnChange,
    id: uniqueId,
    ref: ref,
    disabled: disabled
  })), /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: uniqueId,
    className: "".concat(prefix, "--radio-button__label")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--radio-button__appearance")
  }), labelText && /*#__PURE__*/_react.default.createElement(_Text.Text, {
    className: innerLabelClasses
  }, labelText)));
});

RadioButton.propTypes = {
  /**
   * Specify whether the <RadioButton> is currently checked
   */
  checked: _propTypes.default.bool,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the <RadioButton> should be checked by default
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide a unique id for the underlying `<input>` node
   */
  id: _propTypes.default.string,

  /**
   * Provide where label text should be placed
   * NOTE: `top`/`bottom` are deprecated
   */
  labelPosition: _propTypes.default.oneOf(['right', 'left']),

  /**
   * Provide label text to be read by screen readers when interacting with the
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional `onChange` hook that is called each time the value of
   * the underlying `<input>` changes
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the value of the <RadioButton>
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
};
var _default = RadioButton;
exports.default = _default;