"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["small", "className"];
var prefix = _carbonComponents.settings.prefix;

var SearchSkeleton = function SearchSkeleton(_ref) {
  var _cx;

  var small = _ref.small,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var searchClasses = (0, _classnames.default)(className, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--skeleton"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--xl"), !small), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--sm"), small), _cx));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: searchClasses
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--label")
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--search-input")
  }));
};

SearchSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the Search should be a small variant
   */
  small: _propTypes.default.bool
};
SearchSkeleton.defaultProps = {
  small: false
};
var _default = SearchSkeleton;
exports.default = _default;