"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _FeatureFlags = require("../FeatureFlags");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "id", "inline", "labelText", "disabled", "children", "noLabel", "iconDescription", "hideLabel", "invalid", "invalidText", "helperText", "light", "size", "warn", "warnText"];

var Select = /*#__PURE__*/_react.default.forwardRef(function Select(_ref, ref) {
  var _classNames, _classNames2, _classNames3;

  var className = _ref.className,
      id = _ref.id,
      inline = _ref.inline,
      labelText = _ref.labelText,
      disabled = _ref.disabled,
      children = _ref.children,
      noLabel = _ref.noLabel,
      iconDescription = _ref.iconDescription,
      hideLabel = _ref.hideLabel,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      helperText = _ref.helperText,
      light = _ref.light,
      size = _ref.size,
      warn = _ref.warn,
      warnText = _ref.warnText,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var enabled = (0, _FeatureFlags.useFeatureFlag)('enable-v11-release');
  var selectClasses = (0, _classnames.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select--inline"), inline), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select--invalid"), invalid), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select--disabled"), disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--select--warning"), warn), _classNames), [enabled ? null : className]);
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--visually-hidden"), hideLabel), (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--label--disabled"), disabled), _classNames2));
  var inputClasses = (0, _classnames.default)((_classNames3 = {}, (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--select-input"), true), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--select-input--").concat(size), size), _classNames3));
  var errorId = "".concat(id, "-error-msg");

  var errorText = function () {
    if (invalid) {
      return invalidText;
    }

    if (warn) {
      return warnText;
    }
  }();

  var error = invalid || warn ? /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--form-requirement"),
    id: errorId
  }, errorText) : null;
  var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
    className: helperTextClasses
  }, helperText) : null;
  var ariaProps = {};

  if (invalid) {
    ariaProps['aria-describedby'] = errorId;
  }

  var input = function () {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("select", (0, _extends2.default)({}, other, ariaProps, {
      id: id,
      className: inputClasses,
      disabled: disabled || undefined,
      "aria-invalid": invalid || undefined,
      ref: ref
    }), children), /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, {
      className: "".concat(prefix, "--select__arrow")
    }), invalid && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningFilled16, {
      className: "".concat(prefix, "--select__invalid-icon")
    }), !invalid && warn && /*#__PURE__*/_react.default.createElement(_iconsReact.WarningAltFilled16, {
      className: "".concat(prefix, "--select__invalid-icon ").concat(prefix, "--select__invalid-icon--warning")
    }));
  }();

  return /*#__PURE__*/_react.default.createElement("div", {
    className: enabled ? (0, _classnames.default)("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: selectClasses
  }, !noLabel && /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText), inline && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--select-input--inline__wrapper")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--select-input__wrapper"),
    "data-invalid": invalid || null
  }, input), error), !inline && /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--select-input__wrapper"),
    "data-invalid": invalid || null
  }, input), !inline && error ? error : helper));
});

Select.displayName = 'Select';
Select.propTypes = {
  /**
   * Provide the contents of your Select
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the node containing the label and the select box
   */
  className: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<select>`
   */
  defaultValue: _propTypes.default.any,

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide a description for the twistie icon that can be read by screen readers
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop for `Select` is no longer needed and has ' + 'been deprecated. It will be moved in the next major release.'),

  /**
   * Specify a custom `id` for the `<select>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify whether you want the inline version of this control
   */
  inline: _propTypes.default.bool,

  /**
   * Specify if the currently value is invalid.
   */
  invalid: _propTypes.default.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide label text to be read by screen readers when interacting with the
   * control
   */
  labelText: _propTypes.default.node,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * Reserved for use with <Pagination> component. Will not render a label for the
   * select since Pagination renders one for us.
   */
  noLabel: _propTypes.default.bool,

  /**
   * Provide an optional `onChange` hook that is called each time the value of
   * the underlying `<input>` changes
   */
  onChange: _propTypes.default.func,

  /**
   * Specify the size of the Select Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
};
Select.defaultProps = {
  disabled: false,
  labelText: 'Select',
  inline: false,
  invalid: false,
  invalidText: '',
  helperText: '',
  light: false
};
var _default = Select;
exports.default = _default;