"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["children", "className", "disabled", "index", "name", "onClick", "onKeyDown", "selected", "text"];
var prefix = _carbonComponents.settings.prefix;

var Switch = /*#__PURE__*/_react.default.forwardRef(function Switch(props, tabRef) {
  var children = props.children,
      className = props.className,
      disabled = props.disabled,
      index = props.index,
      name = props.name,
      onClick = props.onClick,
      onKeyDown = props.onKeyDown,
      selected = props.selected,
      text = props.text,
      other = (0, _objectWithoutProperties2.default)(props, _excluded);

  var handleClick = function handleClick(e) {
    e.preventDefault();
    onClick({
      index: index,
      name: name,
      text: text
    });
  };

  var handleKeyDown = function handleKeyDown(event) {
    var key = event.key || event.which;
    onKeyDown({
      index: index,
      name: name,
      text: text,
      key: key
    });
  };

  var classes = (0, _classnames.default)(className, "".concat(prefix, "--content-switcher-btn"), (0, _defineProperty2.default)({}, "".concat(prefix, "--content-switcher--selected"), selected));
  var commonProps = {
    onClick: handleClick,
    onKeyDown: handleKeyDown,
    className: classes,
    disabled: disabled
  };
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    ref: tabRef,
    role: "tab",
    tabIndex: selected ? '0' : '-1',
    "aria-selected": selected
  }, other, commonProps), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--content-switcher__label"),
    title: text
  }, text !== undefined ? text : children));
});

Switch.displayName = 'Switch';
Switch.propTypes = {
  /**
   * Provide child elements to be rendered inside of the Switch
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to your Switch
   */
  className: _propTypes.default.string,

  /**
   * Specify whether or not the Switch should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * The index of your Switch in your ContentSwitcher that is used for event handlers.
   * Reserved for usage in ContentSwitcher
   */
  index: _propTypes.default.number,

  /**
   * Provide the name of your Switch that is used for event handlers
   */
  name: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * A handler that is invoked when a user clicks on the control.
   * Reserved for usage in ContentSwitcher
   */
  onClick: _propTypes.default.func,

  /**
   * A handler that is invoked on the key down event for the control.
   * Reserved for usage in ContentSwitcher
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Whether your Switch is selected. Reserved for usage in ContentSwitcher
   */
  selected: _propTypes.default.bool,

  /**
   * Provide the contents of your Switch
   */
  text: _propTypes.default.string
};
Switch.defaultProps = {
  selected: false,
  text: 'Provide text',
  onClick: function onClick() {},
  onKeyDown: function onKeyDown() {}
};
var _default = Switch;
exports.default = _default;