"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = Tabs;
exports.TabPanels = TabPanels;
exports.TabList = TabList;
exports.TabPanel = exports.Tab = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _keyboard = require("../../../internal/keyboard");

var _usePrefix = require("../../../internal/usePrefix");

var _useId = require("../../../internal/useId");

var _useNoInteractiveChildren = require("../../../internal/useNoInteractiveChildren");

var _useControllableState3 = require("../../../internal/useControllableState");

var _useMergedRefs = require("../../../internal/useMergedRefs");

var _excluded = ["activation", "aria-label", "children", "className", "light", "scrollIntoView", "contained"],
    _excluded2 = ["as", "children", "className", "disabled", "onClick", "onKeyDown"],
    _excluded3 = ["children", "className"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// Used to manage the overall state of the Tabs
var TabsContext = /*#__PURE__*/_react.default.createContext(); // Used to keep track of position in a tablist


var TabContext = /*#__PURE__*/_react.default.createContext(); // Used to keep track of position in a list of tab panels


var TabPanelContext = /*#__PURE__*/_react.default.createContext();

function Tabs(_ref) {
  var children = _ref.children,
      _ref$defaultSelectedI = _ref.defaultSelectedIndex,
      defaultSelectedIndex = _ref$defaultSelectedI === void 0 ? 0 : _ref$defaultSelectedI,
      _onChange = _ref.onChange,
      controlledSelectedIndex = _ref.selectedIndex;
  var baseId = (0, _useId.useId)('ccs'); // The active index is used to track the element which has focus in our tablist

  var _useState = (0, _react.useState)(defaultSelectedIndex),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      activeIndex = _useState2[0],
      setActiveIndex = _useState2[1]; // The selected index is used for the tab/panel pairing which is "visible"


  var _useControllableState = (0, _useControllableState3.useControllableState)({
    value: controlledSelectedIndex,
    defaultValue: defaultSelectedIndex,
    onChange: function onChange(value) {
      if (_onChange) {
        _onChange({
          selectedIndex: value
        });
      }
    }
  }),
      _useControllableState2 = (0, _slicedToArray2.default)(_useControllableState, 2),
      selectedIndex = _useControllableState2[0],
      setSelectedIndex = _useControllableState2[1];

  var value = {
    baseId: baseId,
    activeIndex: activeIndex,
    defaultSelectedIndex: defaultSelectedIndex,
    setActiveIndex: setActiveIndex,
    selectedIndex: selectedIndex,
    setSelectedIndex: setSelectedIndex
  };
  return /*#__PURE__*/_react.default.createElement(TabsContext.Provider, {
    value: value
  }, children);
}

Tabs.propTypes = {
  /**
   * Provide child elements to be rendered inside of the `Tabs`.
   * These elements should render either `TabsList` or `TabsPanels`
   */
  children: _propTypes.default.node,

  /**
   * Specify which content tab should be initially selected when the component
   * is first rendered
   */
  defaultSelectedIndex: _propTypes.default.number,

  /**
   * Provide an optional function which is called whenever the state of the
   * `Tabs` changes
   */
  onChange: _propTypes.default.func,

  /**
   * Control which content panel is currently selected. This puts the component
   * in a controlled mode and should be used along with `onChange`
   */
  selectedIndex: _propTypes.default.number
};

function useEffectOnce(callback) {
  var savedCallback = (0, _react.useRef)(callback);
  var effectGuard = (0, _react.useRef)(false);
  (0, _react.useEffect)(function () {
    savedCallback.current = callback;
  });
  (0, _react.useEffect)(function () {
    if (effectGuard.current !== true) {
      effectGuard.current = true;
      savedCallback.current();
    }
  }, []);
}
/**
 * Get the next index for a given keyboard event given a count of the total
 * items and the current index
 * @param {Event} event
 * @param {number} total
 * @param {number} index
 * @returns {number}
 */


function getNextIndex(event, total, index) {
  if ((0, _keyboard.match)(event, _keyboard.keys.ArrowRight)) {
    return (index + 1) % total;
  } else if ((0, _keyboard.match)(event, _keyboard.keys.ArrowLeft)) {
    return (total + index - 1) % total;
  } else if ((0, _keyboard.match)(event, _keyboard.keys.Home)) {
    return 0;
  } else if ((0, _keyboard.match)(event, _keyboard.keys.End)) {
    return total - 1;
  }
}

function TabList(_ref2) {
  var _cx;

  var _ref2$activation = _ref2.activation,
      activation = _ref2$activation === void 0 ? 'automatic' : _ref2$activation,
      label = _ref2['aria-label'],
      children = _ref2.children,
      customClassName = _ref2.className,
      light = _ref2.light,
      scrollIntoView = _ref2.scrollIntoView,
      _ref2$contained = _ref2.contained,
      contained = _ref2$contained === void 0 ? false : _ref2$contained,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded);

  var _React$useContext = _react.default.useContext(TabsContext),
      activeIndex = _React$useContext.activeIndex,
      selectedIndex = _React$useContext.selectedIndex,
      setSelectedIndex = _React$useContext.setSelectedIndex,
      setActiveIndex = _React$useContext.setActiveIndex;

  var prefix = (0, _usePrefix.usePrefix)();
  var ref = (0, _react.useRef)(null);
  var className = (0, _classnames.default)("".concat(prefix, "--tabs"), customClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tabs--contained"), contained), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--tabs--light"), light), _cx));
  var tabs = [];

  function onKeyDown(event) {
    if ((0, _keyboard.matches)(event, [_keyboard.keys.ArrowRight, _keyboard.keys.ArrowLeft, _keyboard.keys.Home, _keyboard.keys.End])) {
      var activeTabs = tabs.filter(function (tab) {
        return !tab.current.disabled;
      });
      var currentIndex = activeTabs.indexOf(tabs[activation === 'automatic' ? selectedIndex : activeIndex]);
      var nextIndex = tabs.indexOf(activeTabs[getNextIndex(event, activeTabs.length, currentIndex)]);

      if (activation === 'automatic') {
        setSelectedIndex(nextIndex);
      } else if (activation === 'manual') {
        setActiveIndex(nextIndex);
      }

      tabs[nextIndex].current.focus();
    }
  }

  useEffectOnce(function () {
    var tab = tabs[selectedIndex];

    if (scrollIntoView && tab) {
      tab.current.scrollIntoView({
        block: 'nearest',
        inline: 'nearest'
      });
    }
  });
  useEffectOnce(function () {
    if (tabs[selectedIndex].current.disabled) {
      var activeTabs = tabs.filter(function (tab) {
        return !tab.current.disabled;
      });

      if (activeTabs.length > 0) {
        var tab = activeTabs[0];
        setSelectedIndex(tabs.indexOf(tab));
      }
    }
  });
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/interactive-supports-focus
    _react.default.createElement("div", (0, _extends2.default)({}, rest, {
      "aria-label": label,
      ref: ref,
      role: "tablist",
      className: className,
      onKeyDown: onKeyDown
    }), _react.default.Children.map(children, function (child, index) {
      var ref = /*#__PURE__*/_react.default.createRef();

      tabs.push(ref);
      return /*#__PURE__*/_react.default.createElement(TabContext.Provider, {
        value: index
      }, /*#__PURE__*/_react.default.cloneElement(child, {
        ref: ref
      }));
    }))
  );
}

TabList.propTypes = {
  /**
   * Specify whether the content tab should be activated automatically or
   * manually
   */
  activation: _propTypes.default.oneOf(['automatic', 'manual']),

  /**
   * Provide an accessible label to be read when a user interacts with this
   * component
   */
  'aria-label': _propTypes.default.string.isRequired,

  /**
   * Provide child elements to be rendered inside of `ContentTabs`.
   * These elements should render a `ContentTab`
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether component is contained type
   */
  contained: _propTypes.default.bool,

  /**
   * Specify whether or not to use the light component variant
   */
  light: _propTypes.default.bool,

  /**
   * Choose whether or not to automatically scroll to newly selected tabs
   * on component rerender
   */
  scrollIntoView: _propTypes.default.bool
};

var Tab = /*#__PURE__*/_react.default.forwardRef(function Tab(_ref3, ref) {
  var _cx2;

  var _ref3$as = _ref3.as,
      BaseComponent = _ref3$as === void 0 ? 'button' : _ref3$as,
      children = _ref3.children,
      customClassName = _ref3.className,
      disabled = _ref3.disabled,
      _onClick = _ref3.onClick,
      onKeyDown = _ref3.onKeyDown,
      rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded2);
  var prefix = (0, _usePrefix.usePrefix)();

  var _React$useContext2 = _react.default.useContext(TabsContext),
      selectedIndex = _React$useContext2.selectedIndex,
      setSelectedIndex = _React$useContext2.setSelectedIndex,
      baseId = _React$useContext2.baseId;

  var index = _react.default.useContext(TabContext);

  var id = "".concat(baseId, "-tab-").concat(index);
  var panelId = "".concat(baseId, "-tabpanel-").concat(index);
  var className = (0, _classnames.default)("".concat(prefix, "--tabs__nav-item"), "".concat(prefix, "--tabs__nav-link"), customClassName, (_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--tabs__nav-item--selected"), selectedIndex === index), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--tabs__nav-item--disabled"), disabled), _cx2));
  return /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({}, rest, {
    "aria-controls": panelId,
    "aria-disabled": disabled,
    "aria-selected": selectedIndex === index,
    ref: ref,
    id: id,
    role: "tab",
    className: className,
    disabled: disabled,
    onClick: function onClick(evt) {
      if (disabled) {
        return;
      }

      setSelectedIndex(index);

      if (_onClick) {
        _onClick(evt);
      }
    },
    onKeyDown: onKeyDown,
    tabIndex: selectedIndex === index ? '0' : '-1',
    type: "button"
  }), children);
});

exports.Tab = Tab;
Tab.propTypes = {
  /**
   * Provide a custom element to render instead of the default button
   */
  as: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide child elements to be rendered inside of `Tab`.
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to your Tab
   */
  className: _propTypes.default.string,

  /**
   * Whether your Tab is disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: _propTypes.default.func,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: _propTypes.default.func,

  /*
   * An optional parameter to allow overriding the anchor rendering.
   * Useful for using Tab along with react-router or other client
   * side router libraries.
   **/
  renderButton: _propTypes.default.func
};

var TabPanel = /*#__PURE__*/_react.default.forwardRef(function TabPanel(_ref4, forwardRef) {
  var children = _ref4.children,
      customClassName = _ref4.className,
      rest = (0, _objectWithoutProperties2.default)(_ref4, _excluded3);
  var prefix = (0, _usePrefix.usePrefix)();
  var panel = (0, _react.useRef)(null);
  var ref = (0, _useMergedRefs.useMergedRefs)([forwardRef, panel]);

  var _useState3 = (0, _react.useState)('0'),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      tabIndex = _useState4[0],
      setTabIndex = _useState4[1];

  var _React$useContext3 = _react.default.useContext(TabsContext),
      selectedIndex = _React$useContext3.selectedIndex,
      baseId = _React$useContext3.baseId;

  var index = _react.default.useContext(TabPanelContext);

  var id = "".concat(baseId, "-tabpanel-").concat(index);
  var tabId = "".concat(baseId, "-tab-").concat(index);
  var className = (0, _classnames.default)("".concat(prefix, "--tab-content"), customClassName); // tabindex should only be 0 if no interactive content in children

  (0, _react.useEffect)(function () {
    var interactiveContent = (0, _useNoInteractiveChildren.getInteractiveContent)(panel.current);

    if (interactiveContent) {
      setTabIndex('-1');
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    "aria-labelledby": tabId,
    id: id,
    className: className,
    ref: ref,
    role: "tabpanel",
    tabIndex: tabIndex,
    hidden: selectedIndex !== index
  }), children);
});

exports.TabPanel = TabPanel;
TabPanel.propTypes = {
  /**
   * Provide child elements to be rendered inside of `TabPanel`.
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to TabPanel.
   */
  className: _propTypes.default.string
};

function TabPanels(_ref5) {
  var children = _ref5.children;
  return _react.default.Children.map(children, function (child, index) {
    return /*#__PURE__*/_react.default.createElement(TabPanelContext.Provider, {
      value: index
    }, child);
  });
}

TabPanels.propTypes = {
  /**
   * Provide child elements to be rendered inside of `TabPanels`.
   */
  children: _propTypes.default.node
}; // TO DO: implement horizontal scroll and the following props:
// leftOverflowButtonProps
// rightOverflowButtonProps