"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireDefault(require("react"));

var _Tile = require("./Tile");

var _Link = _interopRequireDefault(require("../../Link"));

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

require("@testing-library/jest-dom");

var _enzyme = require("enzyme");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = 'bx';
describe('Default', function () {
  afterEach(_react2.cleanup);
  it('adds extra classes that are passed via className', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tile.Tile, {
      className: "\uD83D\uDE80"
    }, "Default tile", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Link.default, {
      href: "https://www.carbondesignsystem.com"
    }, "Link")));
    expect(_react2.screen.getByText('Default tile').classList.contains('🚀')).toBe(true);
  });
});
describe('ClickableTile', function () {
  afterEach(_react2.cleanup);
  it('renders with a link', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tile.ClickableTile, {
      href: "https://www.carbondesignsystem.com"
    }, "Clickable Tile"));
    expect(_react2.screen.getByRole('link')).toBeInTheDocument();
  });
});
describe('Multi Select', function () {
  afterEach(_react2.cleanup);
  it('does not invoke the click handler if SelectableTile is disabled', function () {
    var onClick = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement("div", {
      role: "group",
      "aria-label": "selectable tiles"
    }, /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, {
      id: "tile-1",
      name: "tiles",
      value: "value",
      onClick: onClick,
      disabled: true
    }, /*#__PURE__*/_react.default.createElement("span", {
      role: "img",
      "aria-label": "vertical traffic light"
    }, "\uD83D\uDEA6"))));

    var tile = _react2.screen.getByText('🚦');

    _userEvent.default.click(tile);

    expect(onClick).not.toHaveBeenCalled();
  });
  it('should cycle elements in document tab order', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement("div", {
      role: "group",
      "aria-label": "selectable tiles"
    }, /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, {
      "data-testid": "element",
      id: "tile-1",
      name: "tiles",
      value: "value"
    }, "tile 1"), /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, {
      "data-testid": "element",
      id: "tile-2",
      name: "tiles",
      value: "value"
    }, "tile 2"), /*#__PURE__*/_react.default.createElement(_Tile.SelectableTile, {
      "data-testid": "element",
      id: "tile-3",
      name: "tiles",
      value: "value"
    }, "tile 3")));

    var _screen$getAllByTestI = _react2.screen.getAllByTestId('element'),
        _screen$getAllByTestI2 = (0, _slicedToArray2.default)(_screen$getAllByTestI, 3),
        id1 = _screen$getAllByTestI2[0],
        id2 = _screen$getAllByTestI2[1],
        id3 = _screen$getAllByTestI2[2];

    expect(document.body).toHaveFocus();

    _userEvent.default.tab();

    expect(id1).toHaveFocus();

    _userEvent.default.tab();

    expect(id2).toHaveFocus();

    _userEvent.default.tab();

    expect(id3).toHaveFocus();

    _userEvent.default.tab(); // cycle goes back to the body element


    expect(document.body).toHaveFocus();

    _userEvent.default.tab();

    expect(id1).toHaveFocus();
  });
});
describe('ExpandableTile', function () {
  var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tile.ExpandableTile, {
    className: "extra-class"
  }, /*#__PURE__*/_react.default.createElement(_Tile.TileAboveTheFoldContent, {
    className: "child"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Test")), /*#__PURE__*/_react.default.createElement(_Tile.TileBelowTheFoldContent, {
    className: "child"
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '500px'
    }
  }, "Test"), /*#__PURE__*/_react.default.createElement("a", {
    id: "test-link",
    href: "/"
  }, "Test Link"))));
  it('renders children as expected', function () {
    expect(wrapper.props().children.length).toBe(2);
  });
  it('has the expected classes', function () {
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--expandable"))).toEqual(true);
  });
  it('renders extra classes passed in via className', function () {
    expect(wrapper.hasClass('extra-class')).toEqual(true);
  });
  it('toggles the expandable class on click', function () {
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(false);
    wrapper.simulate('click');
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(true);
  });
  it('allows click events to be ignored using onBeforeClick', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tile.ExpandableTile, {
      className: "extra-class"
    }, /*#__PURE__*/_react.default.createElement(_Tile.TileAboveTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '200px'
      }
    }, "Test")), /*#__PURE__*/_react.default.createElement(_Tile.TileBelowTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '500px'
      }
    }, "Test"), /*#__PURE__*/_react.default.createElement("a", {
      id: "test-link",
      href: "/"
    }, "Test Link"))));
    wrapper.setProps({
      expanded: false
    });
    wrapper.setProps({
      onBeforeClick: function onBeforeClick(evt) {
        return evt.target.tagName.toLowerCase() !== 'a';
      } // ignore link clicks

    });
    wrapper.simulate('click');
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(true);
    wrapper.find('#test-link').simulate('click');
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(true);
    wrapper.simulate('click');
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(false);
  });
  it('displays the default tooltip for the button', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tile.ExpandableTile, {
      className: "extra-class"
    }, /*#__PURE__*/_react.default.createElement(_Tile.TileAboveTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '200px'
      }
    }, "Test")), /*#__PURE__*/_react.default.createElement(_Tile.TileBelowTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '500px'
      }
    }, "Test"), /*#__PURE__*/_react.default.createElement("a", {
      id: "test-link",
      href: "/"
    }, "Test Link"))));
    var defaultExpandedIconText = 'Interact to collapse Tile';
    var defaultCollapsedIconText = 'Interact to expand Tile'; // Force the expanded tile to be collapsed.

    wrapper.setProps({
      expanded: false
    });
    var collapsedDescription = wrapper.find('button').prop('title');
    expect(collapsedDescription).toEqual(defaultCollapsedIconText); // click on the item to expand it.

    wrapper.simulate('click'); // Validate the description change

    var expandedDescription = wrapper.find('button').prop('title');
    expect(expandedDescription).toEqual(defaultExpandedIconText);
  });
  it('displays the custom tooltips for the button depending on state', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tile.ExpandableTile, {
      className: "extra-class"
    }, /*#__PURE__*/_react.default.createElement(_Tile.TileAboveTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '200px'
      }
    }, "Test")), /*#__PURE__*/_react.default.createElement(_Tile.TileBelowTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '500px'
      }
    }, "Test"), /*#__PURE__*/_react.default.createElement("a", {
      id: "test-link",
      href: "/"
    }, "Test Link"))));
    var tileExpandedIconText = 'Click To Collapse';
    var tileCollapsedIconText = 'Click To Expand'; // Force the custom icon text and the expanded tile to be collapsed.

    wrapper.setProps({
      tileExpandedIconText: tileExpandedIconText,
      tileCollapsedIconText: tileCollapsedIconText,
      expanded: false
    });
    var collapsedDescription = wrapper.find('button').prop('title');
    expect(collapsedDescription).toEqual(tileCollapsedIconText); // click on the item to expand it.

    wrapper.simulate('click'); // Validate the description change

    var expandedDescription = wrapper.find('button').prop('title');
    expect(expandedDescription).toEqual(tileExpandedIconText);
  });
  it('supports setting initial expanded state from props', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tile.ExpandableTile, {
      expanded: true
    }, /*#__PURE__*/_react.default.createElement(_Tile.TileAboveTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '200px'
      }
    }, "Test")), /*#__PURE__*/_react.default.createElement(_Tile.TileBelowTheFoldContent, {
      className: "child"
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        height: '500px'
      }
    }, "Test"))));
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(true);
  });
  it('supports setting expanded state from props', function () {
    wrapper.setProps({
      expanded: true
    });
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(true);
    wrapper.setProps({
      expanded: false
    });
    expect(wrapper.children().hasClass("".concat(prefix, "--tile--is-expanded"))).toEqual(false);
  });
}); // Todo: Testing for a disabled ClickableTile
// Todo: Testing for ExpandableTile
// Todo: Testing for RadioTile