"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DIRECTION_BOTTOM = exports.DIRECTION_RIGHT = exports.DIRECTION_TOP = exports.DIRECTION_LEFT = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _windowOrGlobal = _interopRequireDefault(require("window-or-global"));

var _carbonComponents = require("carbon-components");

var _OptimizedResize = _interopRequireDefault(require("./OptimizedResize"));

var _navigation = require("./keyboard/navigation");

var _warning = require("./warning");

var _wrapFocus = _interopRequireDefault(require("./wrapFocus"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
/**
 * The structure for the position of floating menu.
 * @typedef {object} FloatingMenu~position
 * @property {number} left The left position.
 * @property {number} top The top position.
 * @property {number} right The right position.
 * @property {number} bottom The bottom position.
 */

/**
 * The structure for the size of floating menu.
 * @typedef {object} FloatingMenu~size
 * @property {number} width The width.
 * @property {number} height The height.
 */

/**
 * The structure for the position offset of floating menu.
 * @typedef {object} FloatingMenu~offset
 * @property {number} top The top position.
 * @property {number} left The left position.
 */

/**
 * The structure for the target container.
 * @typedef {object} FloatingMenu~container
 * @property {DOMRect} rect Return of element.getBoundingClientRect()
 * @property {string} position Position style (static, absolute, relative...)
 */

var DIRECTION_LEFT = 'left';
exports.DIRECTION_LEFT = DIRECTION_LEFT;
var DIRECTION_TOP = 'top';
exports.DIRECTION_TOP = DIRECTION_TOP;
var DIRECTION_RIGHT = 'right';
exports.DIRECTION_RIGHT = DIRECTION_RIGHT;
var DIRECTION_BOTTOM = 'bottom';
/**
 * @param {FloatingMenu~offset} [oldMenuOffset={}] The old value.
 * @param {FloatingMenu~offset} [menuOffset={}] The new value.
 * @returns `true` if the parent component wants to change in the adjustment of the floating menu position.
 * @private
 */

exports.DIRECTION_BOTTOM = DIRECTION_BOTTOM;

var hasChangeInOffset = function hasChangeInOffset() {
  var oldMenuOffset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var menuOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if ((0, _typeof2.default)(oldMenuOffset) !== (0, _typeof2.default)(menuOffset)) {
    return true;
  }

  if (Object(menuOffset) === menuOffset && typeof menuOffset !== 'function') {
    return oldMenuOffset.top !== menuOffset.top || oldMenuOffset.left !== menuOffset.left;
  }

  return oldMenuOffset !== menuOffset;
};
/**
 * @param {object} params The parameters.
 * @param {FloatingMenu~size} params.menuSize The size of the menu.
 * @param {FloatingMenu~position} params.refPosition The position of the triggering element.
 * @param {FloatingMenu~offset} [params.offset={ left: 0, top: 0 }] The position offset of the menu.
 * @param {string} [params.direction=bottom] The menu direction.
 * @param {number} [params.scrollX=0] The scroll position of the viewport.
 * @param {number} [params.scrollY=0] The scroll position of the viewport.
 * @param {FloatingMenu~container} [params.container] The size and position type of target element.
 * @returns {FloatingMenu~offset} The position of the menu, relative to the top-left corner of the viewport.
 * @private
 */


var getFloatingPosition = function getFloatingPosition(_ref) {
  var _DIRECTION_LEFT$DIREC;

  var menuSize = _ref.menuSize,
      _ref$refPosition = _ref.refPosition,
      refPosition = _ref$refPosition === void 0 ? {} : _ref$refPosition,
      _ref$offset = _ref.offset,
      offset = _ref$offset === void 0 ? {} : _ref$offset,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? DIRECTION_BOTTOM : _ref$direction,
      _ref$scrollX = _ref.scrollX,
      pageXOffset = _ref$scrollX === void 0 ? 0 : _ref$scrollX,
      _ref$scrollY = _ref.scrollY,
      pageYOffset = _ref$scrollY === void 0 ? 0 : _ref$scrollY,
      container = _ref.container;
  var _refPosition$left = refPosition.left,
      refLeft = _refPosition$left === void 0 ? 0 : _refPosition$left,
      _refPosition$top = refPosition.top,
      refTop = _refPosition$top === void 0 ? 0 : _refPosition$top,
      _refPosition$right = refPosition.right,
      refRight = _refPosition$right === void 0 ? 0 : _refPosition$right,
      _refPosition$bottom = refPosition.bottom,
      refBottom = _refPosition$bottom === void 0 ? 0 : _refPosition$bottom;
  var scrollX = container.position !== 'static' ? 0 : pageXOffset;
  var scrollY = container.position !== 'static' ? 0 : pageYOffset;
  var relativeDiff = {
    top: container.position !== 'static' ? container.rect.top : 0,
    left: container.position !== 'static' ? container.rect.left : 0
  };
  var width = menuSize.width,
      height = menuSize.height;
  var _offset$top = offset.top,
      top = _offset$top === void 0 ? 0 : _offset$top,
      _offset$left = offset.left,
      left = _offset$left === void 0 ? 0 : _offset$left;
  var refCenterHorizontal = (refLeft + refRight) / 2;
  var refCenterVertical = (refTop + refBottom) / 2;
  return (_DIRECTION_LEFT$DIREC = {}, (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, DIRECTION_LEFT, function () {
    return {
      left: refLeft - width + scrollX - left - relativeDiff.left,
      top: refCenterVertical - height / 2 + scrollY + top - 9 - relativeDiff.top
    };
  }), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, DIRECTION_TOP, function () {
    return {
      left: refCenterHorizontal - width / 2 + scrollX + left - relativeDiff.left,
      top: refTop - height + scrollY - top - relativeDiff.top
    };
  }), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, DIRECTION_RIGHT, function () {
    return {
      left: refRight + scrollX + left - relativeDiff.left,
      top: refCenterVertical - height / 2 + scrollY + top + 3 - relativeDiff.top
    };
  }), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, DIRECTION_BOTTOM, function () {
    return {
      left: refCenterHorizontal - width / 2 + scrollX + left - relativeDiff.left,
      top: refBottom + scrollY + top - relativeDiff.top
    };
  }), _DIRECTION_LEFT$DIREC)[direction]();
};
/**
 * A menu that is detached from the triggering element.
 * Useful when the container of the triggering element cannot have `overflow:visible` style, etc.
 */


var FloatingMenu = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(FloatingMenu, _React$Component);

  var _super = _createSuper(FloatingMenu);

  function FloatingMenu() {
    var _this;

    (0, _classCallCheck2.default)(this, FloatingMenu);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_placeInProgress", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      /**
       * The position of the menu, relative to the top-left corner of the viewport.
       * @type {FloatingMenu~offset}
       */
      floatingPosition: undefined
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_menuContainer", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_menuBody", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "startSentinel", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "endSentinel", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_updateMenuSize", function () {
      var prevProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var isAdjustment = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      var menuBody = _this._menuBody;
      process.env.NODE_ENV !== "production" ? (0, _warning.warning)(menuBody, 'The DOM node for menu body for calculating its position is not available. Skipping...') : void 0;

      if (!menuBody) {
        return;
      }

      var _prevProps$menuOffset = prevProps.menuOffset,
          oldMenuOffset = _prevProps$menuOffset === void 0 ? {} : _prevProps$menuOffset,
          oldMenuDirection = prevProps.menuDirection;
      var _this$props = _this.props,
          _this$props$menuOffse = _this$props.menuOffset,
          menuOffset = _this$props$menuOffse === void 0 ? {} : _this$props$menuOffse,
          menuDirection = _this$props.menuDirection;

      if (hasChangeInOffset(oldMenuOffset, menuOffset) || oldMenuDirection !== menuDirection || isAdjustment) {
        var _this$props2 = _this.props,
            flipped = _this$props2.flipped,
            triggerRef = _this$props2.triggerRef,
            updateOrientation = _this$props2.updateOrientation;
        var triggerEl = triggerRef.current;
        var menuSize = menuBody.getBoundingClientRect();
        var refPosition = triggerEl && triggerEl.getBoundingClientRect();
        var offset = typeof menuOffset !== 'function' ? menuOffset : menuOffset(menuBody, menuDirection, triggerEl, flipped); // Optional function to allow parent component to check
        // if the orientation needs to be changed based on params

        if (updateOrientation) {
          updateOrientation({
            menuSize: menuSize,
            refPosition: refPosition,
            direction: menuDirection,
            offset: offset,
            scrollX: _windowOrGlobal.default.pageXOffset,
            scrollY: _windowOrGlobal.default.pageYOffset,
            container: {
              rect: _this.props.target().getBoundingClientRect(),
              position: getComputedStyle(_this.props.target()).position
            }
          });
        } // Skips if either in the following condition:
        // a) Menu body has `display:none`
        // b) `menuOffset` as a callback returns `undefined` (The callback saw that it couldn't calculate the value)


        if (menuSize.width > 0 && menuSize.height > 0 || !offset) {
          _this.setState({
            floatingPosition: getFloatingPosition({
              menuSize: menuSize,
              refPosition: refPosition,
              direction: menuDirection,
              offset: offset,
              scrollX: _windowOrGlobal.default.pageXOffset,
              scrollY: _windowOrGlobal.default.pageYOffset,
              container: {
                rect: _this.props.target().getBoundingClientRect(),
                position: getComputedStyle(_this.props.target()).position
              }
            })
          }, function () {
            if (!isAdjustment) {
              var newMenuSize = menuBody.getBoundingClientRect();

              if (newMenuSize !== menuSize) {
                _this._updateMenuSize(_this.props, true);
              }
            }
          });
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_focusMenuContent", function (menuBody) {
      var primaryFocusNode = menuBody.querySelector(_this.props.selectorPrimaryFocus || null);
      var tabbableNode = menuBody.querySelector(_navigation.selectorTabbable);
      var focusableNode = menuBody.querySelector(_navigation.selectorFocusable);
      var focusTarget = primaryFocusNode || // User defined focusable node
      tabbableNode || // First sequentially focusable node
      focusableNode || // First programmatic focusable node
      menuBody;

      if (_this.props.focusTrap) {
        focusTarget.focus();
      }

      if (focusTarget === menuBody && process.env.NODE_ENV !== "production") {
        process.env.NODE_ENV !== "production" ? (0, _warning.warning)(focusableNode === null, 'Floating Menus must have at least a programmatically focusable child. ' + 'This can be accomplished by adding tabIndex="-1" to the content element.') : void 0;
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_menuRef", function (menuBody) {
      var menuRef = _this.props.menuRef;
      _this._placeInProgress = !!menuBody;
      menuRef && menuRef(_this._menuBody = menuBody);

      if (menuBody) {
        _this._updateMenuSize();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_getChildrenWithProps", function () {
      var _this$props3 = _this.props,
          styles = _this$props3.styles,
          children = _this$props3.children;
      var pos = _this.state.floatingPosition; // If no pos available, we need to hide the element (offscreen to the left)
      // This is done so we can measure the content before positioning it correctly.

      var positioningStyle = pos ? {
        left: "".concat(pos.left, "px"),
        top: "".concat(pos.top, "px"),
        right: 'auto'
      } : {
        visibility: 'hidden',
        top: '0px'
      };
      return /*#__PURE__*/_react.default.cloneElement(children, {
        ref: _this._menuRef,
        style: _objectSpread(_objectSpread(_objectSpread({}, styles), positioningStyle), {}, {
          position: 'absolute',
          opacity: 1
        })
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleBlur", function (_ref2) {
      var oldActiveNode = _ref2.target,
          currentActiveNode = _ref2.relatedTarget;

      if (currentActiveNode && oldActiveNode) {
        var startSentinelNode = _this.startSentinel.current;
        var endSentinelNode = _this.endSentinel.current;
        (0, _wrapFocus.default)({
          bodyNode: _this._menuBody,
          startSentinelNode: startSentinelNode,
          endSentinelNode: endSentinelNode,
          currentActiveNode: currentActiveNode,
          oldActiveNode: oldActiveNode
        });
      }
    });
    return _this;
  }

  (0, _createClass2.default)(FloatingMenu, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.hResize.release();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.hResize = _OptimizedResize.default.add(function () {
        _this2._updateMenuSize();
      });
    }
    /**
     * Set focus on floating menu content after menu placement.
     * @param {Element} menuBody The DOM element of the menu body.
     * @private
     */

  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      this._updateMenuSize(prevProps);

      var onPlace = this.props.onPlace;

      if (this._placeInProgress && this.state.floatingPosition) {
        if (this._menuBody && !this._menuBody.contains(document.activeElement)) {
          this._focusMenuContent(this._menuBody);
        }

        if (typeof onPlace === 'function') {
          onPlace(this._menuBody);
          this._placeInProgress = false;
        }
      }
    }
    /**
     * A callback for called when menu body is mounted or unmounted.
     * @param {Element} menuBody The menu body being mounted. `null` if the menu body is being unmounted.
     */

  }, {
    key: "render",
    value: function render() {
      if (typeof document !== 'undefined') {
        var _this$props4 = this.props,
            focusTrap = _this$props4.focusTrap,
            target = _this$props4.target;
        return /*#__PURE__*/_reactDom.default.createPortal( /*#__PURE__*/_react.default.createElement("div", {
          onBlur: focusTrap ? this.handleBlur : null
        }, /*#__PURE__*/_react.default.createElement("span", {
          ref: this.startSentinel,
          tabIndex: "0",
          role: "link",
          className: "".concat(prefix, "--visually-hidden")
        }, "Focus sentinel"), this._getChildrenWithProps(), /*#__PURE__*/_react.default.createElement("span", {
          ref: this.endSentinel,
          tabIndex: "0",
          role: "link",
          className: "".concat(prefix, "--visually-hidden")
        }, "Focus sentinel")), !target ? document.body : target());
      }

      return null;
    }
  }]);
  return FloatingMenu;
}(_react.default.Component);

(0, _defineProperty2.default)(FloatingMenu, "propTypes", {
  /**
   * Contents to put into the floating menu.
   */
  children: _propTypes.default.object,

  /**
   * `true` if the menu alignment should be flipped.
   */
  flipped: _propTypes.default.bool,

  /**
   * Enable or disable focus trap behavior
   */
  focusTrap: _propTypes.default.bool,

  /**
   * Where to put the tooltip, relative to the trigger button.
   */
  menuDirection: _propTypes.default.oneOf([DIRECTION_LEFT, DIRECTION_TOP, DIRECTION_RIGHT, DIRECTION_BOTTOM]),

  /**
   * The adjustment of the floating menu position, considering the position of dropdown arrow, etc.
   */
  menuOffset: _propTypes.default.oneOfType([_propTypes.default.shape({
    top: _propTypes.default.number,
    left: _propTypes.default.number
  }), _propTypes.default.func]),

  /**
   * The callback called when the menu body has been mounted to/will be unmounted from the DOM.
   */
  menuRef: _propTypes.default.func,

  /**
   * The callback called when the menu body has been mounted and positioned.
   */
  onPlace: _propTypes.default.func,

  /**
   * Specify a CSS selector that matches the DOM element that should
   * be focused when the Modal opens
   */
  selectorPrimaryFocus: _propTypes.default.string,

  /**
   * The additional styles to put to the floating menu.
   */
  styles: _propTypes.default.object,

  /**
   * The query selector indicating where the floating menu body should be placed.
   */
  target: _propTypes.default.func,

  /**
   * The element ref of the tooltip's trigger button.
   */
  triggerRef: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.shape({
    current: _propTypes.default.any
  })]),

  /**
   * Optional function to change orientation of tooltip based on parent
   */
  updateOrientation: _propTypes.default.func
});
(0, _defineProperty2.default)(FloatingMenu, "defaultProps", {
  menuOffset: {},
  menuDirection: DIRECTION_BOTTOM,
  updateOrientation: null
});
var _default = FloatingMenu;
exports.default = _default;