/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// FIXME:
/* eslint-disable react/prop-types */
import React from 'react';
import { eventBus, teeToFile } from '@kui-shell/core';
import InputStripe from '../Client/InputStripe';
import { ContextWidgets, StatusStripe, TabContent, TabModel } from '../..';
import '../../../web/css/static/Popup.scss';
export default class Popup extends React.PureComponent {
    constructor(props) {
        super(props);
        this._inputStripeRef = React.createRef();
        const tabModel = new TabModel();
        eventBus.onceWithTabId('/tab/close/request', tabModel.uuid, (_, tab) => __awaiter(this, void 0, void 0, function* () {
            // tab close is window close for the popup client
            tab.REPL.qexec('window close', undefined, undefined, { tab });
        }));
        eventBus.onCommandComplete(tabModel.uuid, ({ tab, command, response }) => __awaiter(this, void 0, void 0, function* () {
            if (process.env.KUI_TEE_TO_FILE) {
                // tee the response to a file
                // maybe in the future we could do this better
                // e.g. hoistingit to Kui, making it driven off a property rather than env variable
                yield teeToFile(response);
            }
            this.setState({ promptPlaceholder: command });
            this.doFocusInput();
            // see https://github.com/kubernetes-sigs/kui/issues/7268
            setTimeout(() => tab.scrollToBottom(), 50);
            setTimeout(() => tab.scrollToBottom(), 150);
        }));
        this.state = {
            tab: undefined,
            model: tabModel,
            promptPlaceholder: ''
        };
    }
    onTabReady(tab) {
        this.setState({ tab });
        tab.REPL.pexec(this.props.commandLine.join(' '), { tab });
        this.doFocusInput();
    }
    doFocusInput() {
        if (this._inputStripeRef.current) {
            setTimeout(() => this._inputStripeRef.current.doFocus());
        }
    }
    render() {
        return (React.createElement("div", { className: "kui--full-height" },
            React.createElement(TabContent, { noActiveInput: true, uuid: this.state.model.uuid, active: true, state: this.state.model.state, onTabReady: this.onTabReady.bind(this) }),
            React.createElement(StatusStripe, { noHelp: this.props.noHelp, noSettings: this.props.noSettings },
                React.createElement(ContextWidgets, { className: "kui--input-stripe-in-status-stripe" }, this.state.tab && (React.createElement(InputStripe, { ref: this._inputStripeRef, promptPlaceholder: this.state.promptPlaceholder, uuid: this.state.model.uuid, tab: this.state.tab }))),
                this.props.children)));
    }
}
//# sourceMappingURL=Popup.js.map