/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import Icons from '../../spi/Icons';
import Breadcrumb from '../../spi/Breadcrumb';
/**
 * TitleBar
 * ---------------------------------
 * | Kind | Namespace    S | M m x |
 * ---------------------------------
 *
 *  Kind: props.kind
 *  Namespace: props.namespace
 */
export default class Window extends React.PureComponent {
    quitButton() {
        return (React.createElement("div", { className: "sidecar-bottom-stripe-button sidecar-bottom-stripe-quit" },
            React.createElement("a", { href: "#", className: "graphical-icon kui--tab-navigatable kui--notab-when-sidecar-hidden", tabIndex: -1, "aria-label": "Close", onClick: () => this.props.onClose() },
                React.createElement(Icons, { icon: "WindowClose" }))));
    }
    /** back button */
    back() {
        if (this.props.back) {
            return this.props.back.enabled ? (React.createElement("span", { className: "sidecar-bottom-stripe-button" },
                React.createElement("a", { href: "#", className: "graphical-icon kui--tab-navigable" },
                    React.createElement(Icons, { icon: "Back", onClick: this.props.back.onClick, onMouseDown: evt => evt.preventDefault(), className: "kui--sidecar--titlebar-navigation--back" })))) : (React.createElement("span", { className: "sidecar-bottom-stripe-button disabled" },
                React.createElement("a", { className: "disabled graphical-icon" },
                    React.createElement(Icons, { icon: "Back", onClick: this.props.back.onClick, className: "kui--sidecar--titlebar-navigation--back" }))));
        }
    }
    /** forward button */
    forward() {
        if (this.props.forward) {
            return this.props.forward.enabled ? (React.createElement("span", { className: "sidecar-bottom-stripe-button" },
                React.createElement("a", { href: "#", className: "graphical-icon kui--tab-navigable" },
                    React.createElement(Icons, { icon: "Forward", onClick: this.props.forward.onClick, onMouseDown: evt => evt.preventDefault(), className: "kui--sidecar--titlebar-navigation--forward" })))) : (React.createElement("span", { className: "sidecar-bottom-stripe-button disabled" },
                React.createElement("a", { className: "disabled graphical-icon" },
                    React.createElement(Icons, { icon: "Forward", onClick: this.props.forward.onClick, className: "kui--sidecar--titlebar-navigation--forward" }))));
        }
    }
    /** render history navigation UI */
    history() {
        const breadcrumbs = this.props.breadcrumbs && this.props.breadcrumbs.filter(_ => _.label);
        return (React.createElement("div", { className: "kui--sidecar--titlebar-navigation" },
            this.back(),
            this.forward(),
            breadcrumbs && breadcrumbs.length > 0 && React.createElement(Breadcrumb, { breadcrumbs: breadcrumbs, repl: this.props.repl })));
    }
    render() {
        return (React.createElement("div", { className: 'sidecar-bottom-stripe zoomable' + (this.props.breadcrumbs ? ' kui--sidecar--titlebar-has-breadcrumbs' : '') },
            this.history(),
            React.createElement("div", { className: "sidecar-bottom-stripe-left-bits" }),
            React.createElement("div", { className: "sidecar-bottom-stripe-right-bits" },
                React.createElement("div", { className: "sidecar-window-buttons" }, !this.props.notCloseable && this.quitButton()))));
    }
}
//# sourceMappingURL=TitleBar.js.map