/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, Selectors, Util } from '@kui-shell/test';
describe(`bash-like snapshot and replay ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    // should pwd
    const file = Util.uniqueFileForSnapshot();
    let curentDirectory;
    it('should echo current directory', () => CLI.command('pwd', this.app)
        .then(ReplExpect.okWithAny)
        .then(() => __awaiter(this, void 0, void 0, function* () {
        curentDirectory = yield this.app.client.$(Selectors.OUTPUT_LAST).then(_ => _.getText());
    }))
        .catch(Common.oops(this, true)));
    it('should snapshot', () => CLI.command(`snapshot ${file}`, this.app)
        .then(ReplExpect.justOK)
        .catch(Common.oops(this, true)));
    it('should refresh', () => Common.refresh(this));
    it('should replay', () => __awaiter(this, void 0, void 0, function* () {
        try {
            yield CLI.command(`replay ${file}`, this.app);
            // verify the pwd command replay
            let idx = 0;
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const txt = yield this.app.client.$(Selectors.OUTPUT_LAST_PTY).then(_ => _.getText());
                if (++idx > 5) {
                    console.error(`still waiting for expected=${curentDirectory}; actual=${txt}`);
                }
                return txt === curentDirectory;
            }), { timeout: CLI.waitTimeout });
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
//# sourceMappingURL=replay.js.map