/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, Keys, ReplExpect, Selectors, SidecarExpect } from '@kui-shell/test';
import { dirname, join } from 'path';
const ROOT = dirname(require.resolve('@kui-shell/plugin-kubectl/tests/package.json'));
const runTheTests = process.env.MOCHA_RUN_TARGET !== 'webpack' || process.env.KUI_USE_PROXY === 'true';
const pit = runTheTests ? it : xit;
// the sidecar mode presented by the open command
const openMode = 'view';
describe(`rerun command ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    it('should rerun a command that opens the sidecar', () => __awaiter(this, void 0, void 0, function* () {
        try {
            // open the sidecar using `open`
            const res = yield CLI.command(`open ${join(ROOT, 'package.json')}`, this.app);
            yield this.app.client.$(Selectors.SIDECAR(res.count)).then(_ => _.waitForDisplayed());
            yield this.app.client
                .$(Selectors.SIDECAR_MODE_BUTTON_SELECTED(res.count, openMode))
                .then(_ => _.waitForDisplayed());
            // close sidecar
            // await this.app.client.waitForVisible(Selectors.SIDECAR_FULLY_CLOSE_BUTTON)
            // await this.app.client.click(Selectors.SIDECAR_FULLY_CLOSE_BUTTON)
            // await SidecarExpect.fullyClosed(this.app)
            // rerun about
            yield this.app.client.$(Selectors.PROMPT_N(res.count)).then(_ => _.moveTo());
            const rerunButton = yield this.app.client.$(Selectors.COMMAND_RERUN_BUTTON(res.count));
            yield rerunButton.waitForDisplayed();
            yield rerunButton.click();
            // sidecar should open
            yield SidecarExpect.open(res).then(SidecarExpect.mode(openMode));
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    pit('should rerun pwd', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const pwdRes = yield CLI.command('pwd', this.app);
            yield ReplExpect.okWithAny(pwdRes);
            const initialDirectory = yield this.app.client.$(Selectors.OUTPUT_LAST).then(_ => _.getText());
            yield CLI.command('cd /tmp', this.app).then(ReplExpect.okWithAny);
            const cdDirectory = yield this.app.client.$(Selectors.OUTPUT_LAST).then(_ => _.getText());
            yield CLI.command('sleep 1000', this.app); // test if rerun works when there's an active block
            yield this.app.client.$(Selectors.PROMPT_N(pwdRes.count)).then(_ => _.moveTo());
            const rerunButton = yield this.app.client.$(Selectors.COMMAND_RERUN_BUTTON(pwdRes.count));
            yield rerunButton.waitForDisplayed();
            yield rerunButton.click();
            let idx = 0;
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const rerunDirectory = yield this.app.client.$(Selectors.OUTPUT_N_PTY(pwdRes.count)).then(_ => _.getText());
                if (++idx > 5) {
                    console.error(`still waiting for expected=${cdDirectory}; actual=${rerunDirectory}`);
                }
                return rerunDirectory !== initialDirectory && rerunDirectory === cdDirectory;
            }), { timeout: CLI.waitTimeout });
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
describe(`rerun command by clicking the input ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    it('should rerun about by clicking the input', () => __awaiter(this, void 0, void 0, function* () {
        try {
            // do about
            // open the sidecar using `open`
            const res = yield CLI.command(`open ${join(ROOT, 'package.json')}`, this.app)
                .then(SidecarExpect.open)
                .then(SidecarExpect.mode(openMode));
            // close sidecar
            // await this.app.client.waitForVisible(Selectors.SIDECAR_FULLY_CLOSE_BUTTON(res.count))
            // await this.app.client.click(Selectors.SIDECAR_FULLY_CLOSE_BUTTON(res.count))
            // await SidecarExpect.fullyClosed(this.app)
            // rerun about
            yield this.app.client.$(Selectors.PROMPT_N(res.count)).then(_ => _.click());
            yield this.app.client.keys(Keys.ENTER);
            // sidecar should open
            yield SidecarExpect.open(res).then(SidecarExpect.mode(openMode));
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
    pit('should echo 1,11,111 by rerunning the command', () => __awaiter(this, void 0, void 0, function* () {
        try {
            const res = yield CLI.command('echo 1', this.app);
            yield ReplExpect.okWithPtyOutput('1')(res);
            yield this.app.client.$(Selectors.PROMPT_N(res.count)).then(_ => _.click());
            yield this.app.client.keys('1');
            yield this.app.client.keys(Keys.ENTER);
            let idx = 0;
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const expectedText = '11';
                const actualText = yield this.app.client.$(Selectors.OUTPUT_N_PTY(res.count)).then(_ => _.getText());
                if (++idx > 5) {
                    console.error(`still waiting for expected=${expectedText}; actual=${actualText}`);
                }
                return actualText === expectedText;
            }), { timeout: CLI.waitTimeout });
            // test focus by adding another command without return
            yield CLI.command('echo', this.app, true);
            yield this.app.client.$(Selectors.PROMPT_N(res.count)).then(_ => _.click());
            yield this.app.client.keys('1');
            yield this.app.client.keys(Keys.ENTER);
            let jdx = 0;
            yield this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const expectedText = '111';
                const actualText = yield this.app.client.$(Selectors.OUTPUT_N_PTY(res.count)).then(_ => _.getText());
                if (++jdx > 5) {
                    console.error(`still waiting for expected=${expectedText}; actual=${actualText}`);
                }
                return actualText === expectedText;
            }), { timeout: CLI.waitTimeout });
        }
        catch (err) {
            yield Common.oops(this, true)(err);
        }
    }));
});
//# sourceMappingURL=rerun.js.map