export interface Abortable {
    abort(): void;
}
export interface Resizable {
    resize(rows: number, cols: number): void;
}
export declare function isResizable(job: Partial<Resizable>): job is Resizable;
export interface FlowControllable {
    xon(): void;
    xoff(): void;
    write(data: string): void;
}
export declare type Suspendable = Omit<FlowControllable, 'write'>;
/** in the future, a WatchableJob may be more than Abortable, e.g. Suspendable */
export declare type WatchableJob = Abortable & Partial<Suspendable>;
export declare function isSuspendable(watch: Partial<Suspendable>): () => void;
export declare type Job = Abortable & FlowControllable & Partial<Resizable>;
