/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { isHTML } from '../util/types';
import { isHeadless } from '../core/capabilities';
import { isTable } from '../webapp/models/table';
import isMultiModalResponse from './mmr/is';
import { isNavResponse } from './NavResponse';
import { isXtermResponse } from './XtermResponse';
export function isMessageBearingEntity(entity) {
    return entity.message !== undefined;
}
export function isMetadataBearing(spec) {
    const meta = spec;
    return meta !== undefined && meta.metadata !== undefined && meta.metadata.name !== undefined;
}
export function hasDisplayName(resource) {
    const res = resource;
    return isMetadataBearing(resource) && res.spec !== undefined && typeof res.spec.displayName === 'string';
}
export function isMetadataBearingByReference(spec) {
    const ref = spec;
    return ref !== undefined && ref.resource !== undefined && isMetadataBearing(ref.resource);
}
export function isMarkdownResponse(entity) {
    const md = entity;
    return md && typeof md.content === 'string' && md.contentType === 'text/markdown';
}
export function isReactResponse(entity) {
    if (isHeadless()) {
        return false;
    }
    else {
        const { isValidElement } = require('react');
        const response = entity;
        return response && response.react && isValidElement(response.react);
    }
}
export function isMixedResponse(response) {
    return (Array.isArray(response) &&
        response.length > 0 &&
        (typeof response[0] === 'string' || isTable(response[0]) || isHTML(response[0]) || isXtermResponse(response[0])));
}
export function isRawResponse(entity) {
    const raw = entity;
    return raw.mode === 'raw' && raw.content !== undefined;
}
export function isRandomErrorResponse1(response) {
    return typeof response.code === 'string';
}
export function isRandomErrorResponse2(response) {
    const { errno } = response;
    return typeof errno === 'string' && typeof errno === 'number';
}
export function isScalarResponse(response) {
    return !isMultiModalResponse(response) && !isNavResponse(response);
}
export function hasSourceReferences(response) {
    const trait = response;
    return trait && trait.kuiSourceRef !== undefined;
}
export function isAbortableResponse(entity) {
    return typeof entity.abort === 'function';
}
//# sourceMappingURL=entity.js.map