/*
 * Copyright 2017 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { ExecType } from './command';
export function hasLanguage(execOptions) {
    return execOptions.language !== undefined;
}
export function withLanguage(execOptions) {
    if (hasLanguage(execOptions)) {
        return execOptions;
    }
    else {
        return Object.assign({}, execOptions, { language: typeof navigator !== 'undefined' && navigator.language });
    }
}
export class DefaultExecOptions {
    constructor(type = ExecType.TopLevel) {
        this.type = type;
        this.language = typeof navigator !== 'undefined' && navigator.language;
    }
}
export class DefaultExecOptionsForTab extends DefaultExecOptions {
    /**
     * @param execUUID this parameter supports command re-execution; see
     * https://github.com/IBM/kui/issues/5814
     *
     */
    constructor(tab, block, execUUID) {
        super();
        this.execUUID = execUUID;
        this.tab = tab;
        this.block = block;
    }
}
//# sourceMappingURL=execOptions.js.map