"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _carbonComponentsReact = require("carbon-components-react");

var _lodash = _interopRequireDefault(require("lodash"));

var _HTTPClient = _interopRequireDefault(require("../controller/HTTPClient"));

var _searchQueries = require("../definitions/search-queries");

var _i18n = _interopRequireDefault(require("../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

if (!window || !window.navigator || !window.navigator.userAgent) {
  Object.defineProperty(window, 'navigator', {
    value: {
      userAgent: 'node'
    },
    writable: true
  });
  Object.defineProperty(document, 'getElementById', {
    value: val => document.querySelector('#' + val),
    writable: true
  });
}

class Logger extends _react.default.PureComponent {
  constructor(props) {
    super(props);

    this.componentDidMount = () => {
      this.container = this.state.selectedItem;
      this.getLogs();
      this.refresh = setInterval(() => this.isFocused(this.getLogs), 15000);
    };

    this.componentWillUnmount = () => {
      clearInterval(this.refresh);
    };

    this.isFocused = fn => {
      const focus = document.getElementsByClassName('kui--tab-navigatable kui--notab-when-sidecar-hidden bx--tabs__nav-link');
      return document.querySelector('.logs-container__content') && focus[0]['tabIndex'] >= 0 ? fn() : document.querySelector('.visible.sidecar-is-minimized') && document.querySelector('.logs-container__content') ? null : this.componentWillUnmount();
    };

    this.state = {
      selectedItem: _lodash.default.get(this.props.items, '[0]', ''),
      logs: ''
    };
    this.handleOnChange = this.handleOnChange.bind(this);
    this.getLogs = this.getLogs.bind(this);
    this.isFocused = this.isFocused.bind(this);
  }

  handleOnChange(event) {
    this.container = event.selectedItem;
    this.setState({
      logs: ''
    });
    this.getLogs();
    clearInterval(this.refresh);
    this.refresh = setInterval(() => this.isFocused(this.getLogs), 15000);
  }

  getLogs() {
    if (!document.hidden) {
      const node = document.createElement('div');
      node.classList.add('scrollable');
      node.classList.add('bx--structured-list--summary');
      const record = {
        cluster: this.props.data.cluster,
        container: this.container,
        name: this.props.data.name,
        namespace: this.props.data.namespace
      };
      (0, _HTTPClient.default)('post', 'console', (0, _searchQueries.RESOURCE_LOGS)(record)).then(res => {
        this.setState({
          selectedItem: this.container,
          logs: _lodash.default.get(res, 'data.logs', '') !== null ? res.data.logs : (0, _i18n.default)('search.notfound')
        });
      });
    }
  }

  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Dropdown, {
      titleText: "",
      ariaLabel: "",
      id: "resource-container-dropdown",
      label: _lodash.default.get(this.props.items, '[0]', ''),
      items: this.props.items,
      onChange: this.handleOnChange
    }), !this.state.logs ? /*#__PURE__*/_react.default.createElement("div", {
      className: "loading-container"
    }, 'Loading logs') : /*#__PURE__*/_react.default.createElement("div", {
      className: "logs-container__content"
    }, /*#__PURE__*/_react.default.createElement("pre", null, this.state.logs)));
  }

}

exports.default = Logger;
Logger.propTypes = {
  data: _propTypes.default.any,
  items: _propTypes.default.any
};