"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relatedTab = exports.buildRelated = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _carbonComponentsReact = require("carbon-components-react");

var _core = require("@kui-shell/core");

var _i18n = _interopRequireDefault(require("../../util/i18n"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const handleEvent = (resource, event) => {
  var clusters = _lodash.default.get(resource, 'items', '').map(res => res.cluster);

  clusters = clusters.filter((c, index) => clusters.indexOf(c) === index);

  if (event && event.which === 13 || !event) {
    let command = `search kind:${_lodash.default.get(resource, 'kind', '')} `;

    if (clusters && _lodash.default.get(resource, 'kind', '') !== 'cluster') {
      command += `cluster:${clusters.toString()} name:`;
    } else {
      command += 'name:';
    }

    _lodash.default.get(resource, 'items', '').forEach(item => {
      command += `${item.name},`;
    });

    (0, _core.doEval)((0, _core.getCurrentTab)(), undefined, `${command.substring(0, command.length - 1)}`);
  }
};

const buildRelated = (data, type) => {
  const node = document.createElement('div');
  node.classList.add('scrollable');
  node.classList.add(type !== 'query' ? 'bx--structured-list--summary' : 'bx--tile-related');

  const cluster = _lodash.default.get(data, 'items[0].cluster', '');

  const relatedResource = type !== 'query' ? () => {
    return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListWrapper, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListBody, null, data.map(row => /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListRow, {
      key: `${row.kind}`,
      className: "bx--structured-list-rowclick"
    }, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.StructuredListCell, {
      tabIndex: 0,
      onKeyPress: e => handleEvent(row, e),
      onClick: () => handleEvent(row)
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "bx--structured-list-td-related-header"
    }, `${row.items.length}`), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("span", {
      className: "bx--structured-list-td-body"
    }, `Related ${row.kind}`))))));
  } : () => {
    return data.map(row => /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Button, {
      className: `${row.kind}-related-button`,
      tabIndex: 0,
      key: row.kind,
      onClick: () => handleEvent(row, cluster),
      onKeyPress: e => handleEvent(row, e),
      type: "button"
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "bx--tile-container"
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "bx--structured-list-td-related-header"
    }, `${row.items.length}`), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("span", {
      className: "bx--structured-list-td-body"
    }, `Related ${row.kind}`))));
  };

  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(relatedResource), node);

  return node;
};

exports.buildRelated = buildRelated;

const relatedTab = (data, type) => {
  return {
    mode: 'related',
    label: (0, _i18n.default)('search.label.related'),
    order: 9999,
    content: buildRelated(data.related, type)
  };
};

exports.relatedTab = relatedTab;