import { Arguments, Table } from '@kui-shell/core';
import { Explained } from '../../kubectl/explain';
import { KubeOptions } from '../../kubectl/options';
export declare function getTable(drilldownCommand: string, namespace: string, names: string[], explainedKind: Explained, format: string, args: Pick<Arguments<KubeOptions>, 'REPL' | 'parsedOptions' | 'execOptions'>, needsStatusColumn?: boolean, customColumns?: string[]): Promise<string | Table>;
/**
 * Direct `get` only handles the following cases:
 *
 * 1. file request with table output, e.g. `kubectl get -f` and `kubectl get -k`
 * 2. table request, e.g. `kubectl get pods` and `kubectl get pod nginx`
 * 3. entity request with kind and name, e.g. `get pod nginx -o yaml`
 *
 * TODO 1: consolidate `1` and `2` into a single table request handler using `doStatus`
 * TODO 2: handle entity request with file
 *
 */
export declare function get(drilldownCommand: string, namespace: string, names: string[], explainedKind: Explained, format: string, args: Arguments<KubeOptions>): Promise<string | Table<import("@kui-shell/core").Row> | {
    content: {
        code: number;
        stderr: string;
        stdout: string;
        wasSentToPty: boolean;
    };
}>;
export default function getDirect(args: Arguments<KubeOptions>, _kind: Promise<Explained>): Promise<string | Table<import("@kui-shell/core").Row> | {
    content: {
        code: number;
        stderr: string;
        stdout: string;
        wasSentToPty: boolean;
    };
}>;
