/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import prettyPrintDuration from 'pretty-ms';
import toMap from '../../table-to-map';
import { withKubeconfigFrom } from '../../../../../controller/kubectl/options';
export function none() {
    return '<none>';
}
export function age({ metadata }, now = new Date()) {
    return prettyPrintDuration((typeof now === 'string' ? new Date(now) : now).getTime() - new Date(metadata.creationTimestamp).getTime());
}
export default function GenericSummary(resource, repl) {
    return __awaiter(this, void 0, void 0, function* () {
        // a command that will fetch a single-row table
        const cmd = withKubeconfigFrom(resource.originatingCommand, `kubectl get ${resource.kind} ${resource.metadata.name} -n ${resource.metadata.namespace} -o wide`);
        return toMap(yield repl.qexec(cmd));
    });
}
//# sourceMappingURL=Generic.js.map