var _excluded = ["stacked"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text } from '@storybook/addon-knobs';
import { iconAddSolid, iconSearch } from 'carbon-icons';
import { Add16, AddFilled16, Search16, PlayOutlineFilled32, PlayOutlineFilled16 } from '@carbon/icons-react';
import Button from '../Button';
import ButtonSkeleton from '../Button/Button.Skeleton';
import ButtonSet from '../ButtonSet';
import mdx from './Button.mdx';
var icons = {
  None: 'None',
  'Add (Add16 from `@carbon/icons-react`)': 'Add16',
  'Add (Filled) (AddFilled16 from `@carbon/icons-react`)': 'AddFilled16',
  'Search (Search16 from `@carbon/icons-react`)': 'Search16',
  'PlayOutlineFilled16 (PlayOutlineFilled16 from `@carbon/icons-react`)': 'PlayOutlineFilled16',
  'PlayOutlineFilled32 (PlayOutlineFilled32 from `@carbon/icons-react`)': 'PlayOutlineFilled32'
};
var iconMap = {
  iconAddSolid: iconAddSolid,
  iconSearch: iconSearch,
  Add16: Add16,
  AddFilled16: AddFilled16,
  Search16: Search16,
  PlayOutlineFilled16: PlayOutlineFilled16,
  PlayOutlineFilled32: PlayOutlineFilled32
};
var kinds = {
  'Primary button (primary)': 'primary',
  'Secondary button (secondary)': 'secondary',
  'Tertiary button (tertiary)': 'tertiary',
  'Danger button (danger)': 'danger',
  'Danger tertiary button (danger--tertiary)': 'danger--tertiary',
  'Danger ghost button (danger--ghost)': 'danger--ghost',
  'Ghost button (ghost)': 'ghost'
}; // V11: New size table
// const sizes = {
//   'Small  (sm)': 'sm',
//   'Medium (md)': 'md',
//   'Large  (lg)  - default': null,
//   'Extra Large (xl)': 'xl',
//   'Extra Extra Large (2xl)': '2xl',
// };

var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md)': 'md',
  Default: null,
  'Large (lg)': 'lg',
  'Extra Large (xl)': 'xl'
};
var props = {
  regular: function regular() {
    var iconToUse = iconMap[select('Icon (icon)', icons, 'none')];
    return {
      className: 'some-class',
      isExpressive: boolean('Expressive', false),
      kind: select('Button kind (kind)', kinds, 'primary'),
      disabled: boolean('Disabled (disabled)', false),
      size: select('Button size (size)', sizes, 'default'),
      renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
      iconDescription: text('Icon description (iconDescription)', 'Button icon'),
      onClick: action('onClick'),
      onFocus: action('onFocus')
    };
  },
  iconOnly: function iconOnly() {
    var iconToUse;

    if (iconMap[select('Icon (icon)', icons, 'Add16')] == undefined) {
      iconToUse = Add16;
    } else {
      iconToUse = iconMap[select('Icon (icon)', icons, 'Add16')];
    }

    return {
      className: 'some-class',
      isExpressive: boolean('Expressive', false),
      kind: select('Button kind (kind)', kinds, 'primary'),
      disabled: boolean('Disabled (disabled)', false),
      isSelected: boolean('Selected (isSelected)', false),
      size: select('Button size (size)', sizes, 'default'),
      renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
      iconDescription: text('Icon description (iconDescription)', 'Button icon'),
      tooltipPosition: select('Tooltip position (tooltipPosition)', ['top', 'right', 'bottom', 'left'], 'bottom'),
      tooltipAlignment: select('Tooltip alignment (tooltipAlignment)', ['start', 'center', 'end'], 'center'),
      onClick: action('onClick'),
      onFocus: action('onFocus')
    };
  },
  set: function set() {
    var iconToUse = iconMap[select('Icon (icon)', icons, 'none')];
    return {
      className: 'some-class',
      isExpressive: boolean('Expressive', false),
      disabled: boolean('Disabled (disabled)', false),
      size: select('Button size (size)', sizes, 'default'),
      renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
      iconDescription: text('Icon description (iconDescription)', 'Button icon'),
      stacked: boolean('Stack buttons vertically (stacked)', false),
      onClick: action('onClick'),
      onFocus: action('onFocus')
    };
  }
};
export default {
  title: 'Components/Button',
  decorators: [withKnobs],
  parameters: {
    component: Button,
    subcomponents: {
      ButtonSet: ButtonSet,
      ButtonSkeleton: ButtonSkeleton
    },
    docs: {
      page: mdx
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement(Button, null, "Button");
};
_Default.story = {
  name: 'Button'
};
export var Secondary = function Secondary() {
  return /*#__PURE__*/React.createElement(Button, {
    kind: "secondary"
  }, "Button");
};
export var Tertiary = function Tertiary() {
  return /*#__PURE__*/React.createElement(Button, {
    kind: "tertiary"
  }, "Button");
};
export var Danger = function Danger() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, {
    kind: "danger"
  }, "Button"), "\xA0", /*#__PURE__*/React.createElement(Button, {
    kind: "danger--tertiary"
  }, "Tertiary Danger Button"), "\xA0", /*#__PURE__*/React.createElement(Button, {
    kind: "danger--ghost"
  }, "Ghost Danger Button"));
};
export var Ghost = function Ghost() {
  return /*#__PURE__*/React.createElement(Button, {
    kind: "ghost"
  }, "Button");
};
export var Playground = function Playground() {
  var regularProps = props.regular();
  var iconOnly = props.iconOnly();

  var _props$set = props.set(),
      stacked = _props$set.stacked,
      buttonProps = _objectWithoutProperties(_props$set, _excluded);

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    style: {
      display: 'flex',
      alignItems: 'center',
      flexWrap: 'wrap'
    }
  }, /*#__PURE__*/React.createElement(Button, regularProps, "Buttons"), "\xA0", !regularProps.kind.includes('danger') && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, _extends({
    hasIconOnly: true
  }, iconOnly)), "\xA0", /*#__PURE__*/React.createElement(Button, _extends({
    hasIconOnly: true
  }, iconOnly, {
    kind: "ghost"
  })))), /*#__PURE__*/React.createElement("div", {
    style: {
      marginTop: '1rem'
    }
  }, /*#__PURE__*/React.createElement(ButtonSet, {
    stacked: stacked
  }, /*#__PURE__*/React.createElement(Button, _extends({
    kind: "secondary"
  }, buttonProps), "Secondary button"), /*#__PURE__*/React.createElement(Button, _extends({
    kind: "primary"
  }, buttonProps), "Primary button"))));
};
export var IconButton = function IconButton() {
  return /*#__PURE__*/React.createElement(Button, {
    renderIcon: Add16,
    iconDescription: "Icon Description",
    hasIconOnly: true,
    onClick: action('onClick')
  });
};
IconButton.story = {
  name: 'Icon Button'
};
export var SetOfButtons = function SetOfButtons() {
  return /*#__PURE__*/React.createElement(ButtonSet, null, /*#__PURE__*/React.createElement(Button, {
    kind: "secondary"
  }, "Secondary button"), /*#__PURE__*/React.createElement(Button, {
    kind: "primary"
  }, "Primary button"));
};
export var ExpressiveButtons = function ExpressiveButtons() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/React.createElement(Button, {
    isExpressive: true,
    size: "default"
  }, "Button")), /*#__PURE__*/React.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/React.createElement(Button, {
    isExpressive: true,
    size: "lg"
  }, "Button")), /*#__PURE__*/React.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/React.createElement(Button, {
    isExpressive: true,
    size: "xl"
  }, "Button")), /*#__PURE__*/React.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/React.createElement(Button, {
    isExpressive: true,
    size: "default",
    renderIcon: Add16
  }, "Button")), /*#__PURE__*/React.createElement("div", {
    style: {
      margin: '1rem'
    }
  }, /*#__PURE__*/React.createElement(Button, {
    isExpressive: true,
    renderIcon: Add16,
    hasIconOnly: true,
    iconDescription: "Icon description"
  })), /*#__PURE__*/React.createElement("div", {
    style: {
      marginTop: '1rem'
    }
  }, /*#__PURE__*/React.createElement(ButtonSet, null, /*#__PURE__*/React.createElement(Button, {
    kind: "secondary",
    isExpressive: true
  }, "Secondary button"), /*#__PURE__*/React.createElement(Button, {
    kind: "primary",
    isExpressive: true
  }, "Primary button"))));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(ButtonSkeleton, {
    size: "xl"
  }), "\xA0", /*#__PURE__*/React.createElement(ButtonSkeleton, {
    size: "lg"
  }), "\xA0", /*#__PURE__*/React.createElement(ButtonSkeleton, null), "\xA0", /*#__PURE__*/React.createElement(ButtonSkeleton, {
    size: "md"
  }), "\xA0", /*#__PURE__*/React.createElement(ButtonSkeleton, {
    small: true
  }));
};