var _excluded = ["className", "type", "children", "disabled", "feedback", "feedbackTimeout", "onClick", "ariaLabel", "copyLabel", "copyButtonDescription", "light", "showMoreText", "showLessText", "hideCopyButton", "wrapText", "maxCollapsedNumberOfRows", "maxExpandedNumberOfRows", "minCollapsedNumberOfRows", "minExpandedNumberOfRows"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useState, useRef, useEffect, useCallback } from 'react';
import classNames from 'classnames';
import useResizeObserver from 'use-resize-observer/polyfilled';
import debounce from 'lodash.debounce';
import { ChevronDown16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import Copy from '../Copy';
import Button from '../Button';
import CopyButton from '../CopyButton';
import getUniqueId from '../../tools/uniqueId';
import copy from 'copy-to-clipboard';
var prefix = settings.prefix;
var rowHeightInPixels = 16;
var defaultMaxCollapsedNumberOfRows = 15;
var defaultMaxExpandedNumberOfRows = 0;
var defaultMinCollapsedNumberOfRows = 3;
var defaultMinExpandedNumberOfRows = 16;

function CodeSnippet(_ref) {
  var _classNames;

  var className = _ref.className,
      type = _ref.type,
      children = _ref.children,
      disabled = _ref.disabled,
      feedback = _ref.feedback,
      feedbackTimeout = _ref.feedbackTimeout,
      onClick = _ref.onClick,
      ariaLabel = _ref.ariaLabel,
      copyLabel = _ref.copyLabel,
      copyButtonDescription = _ref.copyButtonDescription,
      light = _ref.light,
      showMoreText = _ref.showMoreText,
      showLessText = _ref.showLessText,
      hideCopyButton = _ref.hideCopyButton,
      wrapText = _ref.wrapText,
      _ref$maxCollapsedNumb = _ref.maxCollapsedNumberOfRows,
      maxCollapsedNumberOfRows = _ref$maxCollapsedNumb === void 0 ? defaultMaxCollapsedNumberOfRows : _ref$maxCollapsedNumb,
      _ref$maxExpandedNumbe = _ref.maxExpandedNumberOfRows,
      maxExpandedNumberOfRows = _ref$maxExpandedNumbe === void 0 ? defaultMaxExpandedNumberOfRows : _ref$maxExpandedNumbe,
      _ref$minCollapsedNumb = _ref.minCollapsedNumberOfRows,
      minCollapsedNumberOfRows = _ref$minCollapsedNumb === void 0 ? defaultMinCollapsedNumberOfRows : _ref$minCollapsedNumb,
      _ref$minExpandedNumbe = _ref.minExpandedNumberOfRows,
      minExpandedNumberOfRows = _ref$minExpandedNumbe === void 0 ? defaultMinExpandedNumberOfRows : _ref$minExpandedNumbe,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      expandedCode = _useState2[0],
      setExpandedCode = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      shouldShowMoreLessBtn = _useState4[0],
      setShouldShowMoreLessBtn = _useState4[1];

  var _useRef = useRef(getUniqueId()),
      uid = _useRef.current;

  var codeContentRef = useRef();
  var codeContainerRef = useRef();

  var _useState5 = useState(false),
      _useState6 = _slicedToArray(_useState5, 2),
      hasLeftOverflow = _useState6[0],
      setHasLeftOverflow = _useState6[1];

  var _useState7 = useState(false),
      _useState8 = _slicedToArray(_useState7, 2),
      hasRightOverflow = _useState8[0],
      setHasRightOverflow = _useState8[1];

  var getCodeRef = useCallback(function () {
    if (type === 'single') {
      return codeContainerRef;
    }

    if (type === 'multi') {
      return codeContentRef;
    }
  }, [type]);
  var getCodeRefDimensions = useCallback(function () {
    var _getCodeRef$current = getCodeRef().current,
        codeClientWidth = _getCodeRef$current.clientWidth,
        codeScrollLeft = _getCodeRef$current.scrollLeft,
        codeScrollWidth = _getCodeRef$current.scrollWidth;
    return {
      horizontalOverflow: codeScrollWidth > codeClientWidth,
      codeClientWidth: codeClientWidth,
      codeScrollWidth: codeScrollWidth,
      codeScrollLeft: codeScrollLeft
    };
  }, [getCodeRef]);
  var handleScroll = useCallback(function () {
    if (type === 'inline' || type === 'single' && !(codeContainerRef !== null && codeContainerRef !== void 0 && codeContainerRef.current) || type === 'multi' && !(codeContentRef !== null && codeContentRef !== void 0 && codeContentRef.current)) {
      return;
    }

    var _getCodeRefDimensions = getCodeRefDimensions(),
        horizontalOverflow = _getCodeRefDimensions.horizontalOverflow,
        codeClientWidth = _getCodeRefDimensions.codeClientWidth,
        codeScrollWidth = _getCodeRefDimensions.codeScrollWidth,
        codeScrollLeft = _getCodeRefDimensions.codeScrollLeft;

    setHasLeftOverflow(horizontalOverflow && !!codeScrollLeft);
    setHasRightOverflow(horizontalOverflow && codeScrollLeft + codeClientWidth !== codeScrollWidth);
  }, [type, getCodeRefDimensions]);
  useResizeObserver({
    ref: getCodeRef(),
    onResize: function onResize() {
      if (codeContentRef !== null && codeContentRef !== void 0 && codeContentRef.current && type === 'multi') {
        var _codeContentRef$curre = codeContentRef.current.getBoundingClientRect(),
            height = _codeContentRef$curre.height;

        if (maxCollapsedNumberOfRows > 0 && (maxExpandedNumberOfRows <= 0 || maxExpandedNumberOfRows > maxCollapsedNumberOfRows) && height > maxCollapsedNumberOfRows * rowHeightInPixels) {
          setShouldShowMoreLessBtn(true);
        } else {
          setShouldShowMoreLessBtn(false);
        }

        if (expandedCode && minExpandedNumberOfRows > 0 && height <= minExpandedNumberOfRows * rowHeightInPixels) {
          setExpandedCode(false);
        }
      }

      if (codeContentRef !== null && codeContentRef !== void 0 && codeContentRef.current && type === 'multi' || codeContainerRef !== null && codeContainerRef !== void 0 && codeContainerRef.current && type === 'single') {
        debounce(handleScroll, 200);
      }
    }
  }, [type, maxCollapsedNumberOfRows, maxExpandedNumberOfRows, minExpandedNumberOfRows, rowHeightInPixels]);
  useEffect(function () {
    handleScroll();
  }, [handleScroll]);

  var handleCopyClick = function handleCopyClick(evt) {
    copy(children);

    if (onClick) {
      onClick(evt);
    }
  };

  var codeSnippetClasses = classNames(className, "".concat(prefix, "--snippet"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--snippet--").concat(type), type), _defineProperty(_classNames, "".concat(prefix, "--snippet--disabled"), type !== 'inline' && disabled), _defineProperty(_classNames, "".concat(prefix, "--snippet--expand"), expandedCode), _defineProperty(_classNames, "".concat(prefix, "--snippet--light"), light), _defineProperty(_classNames, "".concat(prefix, "--snippet--no-copy"), hideCopyButton), _defineProperty(_classNames, "".concat(prefix, "--snippet--wraptext"), wrapText), _classNames));
  var expandCodeBtnText = expandedCode ? showLessText : showMoreText;

  if (type === 'inline') {
    if (hideCopyButton) {
      return /*#__PURE__*/React.createElement("span", {
        className: codeSnippetClasses
      }, /*#__PURE__*/React.createElement("code", {
        id: uid
      }, children));
    }

    return /*#__PURE__*/React.createElement(Copy, _extends({}, rest, {
      onClick: handleCopyClick,
      "aria-label": copyLabel || ariaLabel,
      "aria-describedby": uid,
      className: codeSnippetClasses,
      feedback: feedback,
      feedbackTimeout: feedbackTimeout
    }), /*#__PURE__*/React.createElement("code", {
      id: uid
    }, children));
  }

  var containerStyle = {};

  if (type === 'multi') {
    var styles = {};

    if (expandedCode) {
      if (maxExpandedNumberOfRows > 0) {
        styles.maxHeight = maxExpandedNumberOfRows * rowHeightInPixels;
      }

      if (minExpandedNumberOfRows > 0) {
        styles.minHeight = minExpandedNumberOfRows * rowHeightInPixels;
      }
    } else {
      if (maxCollapsedNumberOfRows > 0) {
        styles.maxHeight = maxCollapsedNumberOfRows * rowHeightInPixels;
      }

      if (minCollapsedNumberOfRows > 0) {
        styles.minHeight = minCollapsedNumberOfRows * rowHeightInPixels;
      }
    }

    if (Object.keys(styles).length) {
      containerStyle.style = styles;
    }
  }

  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    className: codeSnippetClasses
  }), /*#__PURE__*/React.createElement("div", _extends({
    ref: codeContainerRef,
    role: type === 'single' ? 'textbox' : null,
    tabIndex: type === 'single' && !disabled ? 0 : null,
    className: "".concat(prefix, "--snippet-container"),
    "aria-label": ariaLabel || copyLabel || 'code-snippet',
    onScroll: type === 'single' && handleScroll || null
  }, containerStyle), /*#__PURE__*/React.createElement("pre", {
    ref: codeContentRef,
    onScroll: type === 'multi' && handleScroll || null
  }, /*#__PURE__*/React.createElement("code", null, children))), hasLeftOverflow && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--snippet__overflow-indicator--left")
  }), hasRightOverflow && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--snippet__overflow-indicator--right")
  }), !hideCopyButton && /*#__PURE__*/React.createElement(CopyButton, {
    disabled: disabled,
    onClick: handleCopyClick,
    feedback: feedback,
    feedbackTimeout: feedbackTimeout,
    iconDescription: copyButtonDescription
  }), shouldShowMoreLessBtn && /*#__PURE__*/React.createElement(Button, {
    kind: "ghost",
    size: "field",
    className: "".concat(prefix, "--snippet-btn--expand"),
    disabled: disabled,
    onClick: function onClick() {
      return setExpandedCode(!expandedCode);
    }
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--snippet-btn--text")
  }, expandCodeBtnText), /*#__PURE__*/React.createElement(ChevronDown16, {
    "aria-label": expandCodeBtnText,
    className: "".concat(prefix, "--icon-chevron--down ").concat(prefix, "--snippet__icon"),
    name: "chevron--down",
    role: "img"
  })));
}

CodeSnippet.propTypes = {
  /**
   * Specify a label to be read by screen readers on the containing <textbox>
   * node
   */
  ariaLabel: PropTypes.string,

  /**
   * Provide the content of your CodeSnippet as a string
   */
  children: PropTypes.string,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the description for the Copy Button
   */
  copyButtonDescription: PropTypes.string,

  /**
   * Specify a label to be read by screen readers on the containing <textbox>
   * node
   */
  copyLabel: PropTypes.string,

  /**
   * Specify whether or not the CodeSnippet should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify the string displayed when the snippet is copied
   */
  feedback: PropTypes.string,

  /**
   * Specify the time it takes for the feedback message to timeout
   */
  feedbackTimeout: PropTypes.number,

  /**
   * Specify whether or not a copy button should be used/rendered.
   */
  hideCopyButton: PropTypes.bool,

  /**
   * Specify whether you are using the light variant of the Code Snippet,
   * typically used for inline snippet to display an alternate color
   */
  light: PropTypes.bool,

  /**
   * Specify the maximum number of rows to be shown when in collapsed view
   */
  maxCollapsedNumberOfRows: PropTypes.number,

  /**
   * Specify the maximum number of rows to be shown when in expanded view
   */
  maxExpandedNumberOfRows: PropTypes.number,

  /**
   * Specify the minimum number of rows to be shown when in collapsed view
   */
  minCollapsedNumberOfRows: PropTypes.number,

  /**
   * Specify the minimum number of rows to be shown when in expanded view
   */
  minExpandedNumberOfRows: PropTypes.number,

  /**
   * An optional handler to listen to the `onClick` even fired by the Copy
   * Button
   */
  onClick: PropTypes.func,

  /**
   * Specify a string that is displayed when the Code Snippet has been
   * interacted with to show more lines
   */
  showLessText: PropTypes.string,

  /**
   * Specify a string that is displayed when the Code Snippet text is more
   * than 15 lines
   */
  showMoreText: PropTypes.string,

  /**
   * Provide the type of Code Snippet
   */
  type: PropTypes.oneOf(['single', 'inline', 'multi']),

  /**
   * Specify whether or not to wrap the text.
   */
  wrapText: PropTypes.bool
};
CodeSnippet.defaultProps = {
  type: 'single',
  showMoreText: 'Show more',
  showLessText: 'Show less',
  wrapText: false
};
export default CodeSnippet;