var _excluded = ["showHeaders"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { withKnobs, boolean } from '@storybook/addon-knobs';
import DataTableSkeleton from '../DataTableSkeleton';
import { headers } from '../DataTable/stories/shared';

var props = function props() {
  return {
    showHeaders: boolean('Show table headers', true),
    zebra: boolean('Use zebra stripe (zebra)', false),
    compact: boolean('Compact variant (compact)', false),
    showHeader: boolean('Show the Table Header (showHeader)', true),
    showToolbar: boolean('Show the Table Toolbar (showToolbar)', true)
  };
};

export default {
  title: 'Components/DataTable',
  decorators: [withKnobs],
  parameters: {
    component: DataTableSkeleton
  }
};
export var Skeleton = function Skeleton() {
  var _props = props(),
      showHeaders = _props.showHeaders,
      rest = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '800px'
    }
  }, /*#__PURE__*/React.createElement(DataTableSkeleton, _extends({}, rest, {
    headers: showHeaders ? headers : null
  })), /*#__PURE__*/React.createElement("br", null));
};
Skeleton.storyName = 'default';
Skeleton.parameters = {
  info: {
    text: "\n        Skeleton states are used as a progressive loading state while the user waits for content to load.\n\n        This example shows a skeleton state for a data table.\n      "
  }
};