var _excluded = ["uuid", "name", "status", "iconDescription", "onDelete", "invalid", "errorSubject", "errorBody", "size"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { settings } from 'carbon-components';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useRef } from 'react';
import Filename from './Filename';
import { keys, matches } from '../../internal/keyboard';
import uid from '../../tools/uniqueId';
var prefix = settings.prefix;

function FileUploaderItem(_ref) {
  var _cx;

  var uuid = _ref.uuid,
      name = _ref.name,
      status = _ref.status,
      iconDescription = _ref.iconDescription,
      onDelete = _ref.onDelete,
      invalid = _ref.invalid,
      errorSubject = _ref.errorSubject,
      errorBody = _ref.errorBody,
      size = _ref.size,
      other = _objectWithoutProperties(_ref, _excluded);

  var _useRef = useRef(uuid || uid()),
      id = _useRef.current;

  var classes = cx("".concat(prefix, "--file__selected-file"), (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--file__selected-file--invalid"), invalid), _defineProperty(_cx, "".concat(prefix, "--file__selected-file--md"), size === 'field' || size === 'md'), _defineProperty(_cx, "".concat(prefix, "--file__selected-file--sm"), size === 'small' || size === 'sm'), _cx));
  return /*#__PURE__*/React.createElement("span", _extends({
    className: classes
  }, other), /*#__PURE__*/React.createElement("p", {
    className: "".concat(prefix, "--file-filename"),
    title: name
  }, name), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--file__state-container")
  }, /*#__PURE__*/React.createElement(Filename, {
    iconDescription: iconDescription,
    status: status,
    invalid: invalid,
    onKeyDown: function onKeyDown(evt) {
      if (matches(evt, [keys.Enter, keys.Space])) {
        if (status === 'edit') {
          onDelete(evt, {
            uuid: id
          });
        }
      }
    },
    onClick: function onClick(evt) {
      if (status === 'edit') {
        onDelete(evt, {
          uuid: id
        });
      }
    }
  })), invalid && errorSubject && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form-requirement")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form-requirement__title")
  }, errorSubject), errorBody && /*#__PURE__*/React.createElement("p", {
    className: "".concat(prefix, "--form-requirement__supplement")
  }, errorBody)));
}

FileUploaderItem.propTypes = {
  /**
   * Error message body for an invalid file upload
   */
  errorBody: PropTypes.string,

  /**
   * Error message subject for an invalid file upload
   */
  errorSubject: PropTypes.string,

  /**
   * Description of status icon (displayed in native tooltip)
   */
  iconDescription: PropTypes.string,

  /**
   * Specify if the currently uploaded file is invalid
   */
  invalid: PropTypes.bool,

  /**
   * Name of the uploaded file
   */
  name: PropTypes.string,

  /**
   * Event handler that is called after removing a file from the file uploader
   * The event handler signature looks like `onDelete(evt, { uuid })`
   */
  onDelete: PropTypes.func,

  /**
   * Specify the size of the uploaded items, from a list of available
   * sizes. For `default` buttons, this prop can remain unspecified.
   * V11: `default`, `field`, and `small` will be removed
   */
  size: PropTypes.oneOf(['default', 'field', 'small', 'sm', 'md', 'lg']),

  /**
   * Status of the file upload
   */
  status: PropTypes.oneOf(['uploading', 'edit', 'complete']),

  /**
   * Unique identifier for the file object
   */
  uuid: PropTypes.string
};
FileUploaderItem.defaultProps = {
  status: 'uploading',
  onDelete: function onDelete() {}
};
export default FileUploaderItem;