var _excluded = ["children", "disabled", "indented", "kind", "label", "level", "onClick", "renderIcon", "shortcut"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useRef, useEffect } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import { CaretRight16 } from '@carbon/icons-react';
import { keys, match } from '../../internal/keyboard';
import { getFirstSubNode, focusNode, getParentMenu, clickedElementHasSubnodes } from './_utils';
import Menu from './Menu';
var prefix = settings.prefix;
var hoverIntentDelay = 150; // in ms

function MenuOptionContent(_ref) {
  var label = _ref.label,
      info = _ref.info,
      disabled = _ref.disabled,
      Icon = _ref.icon,
      indented = _ref.indented;
  var classes = classnames("".concat(prefix, "--menu-option__content"), _defineProperty({}, "".concat(prefix, "--menu-option__content--disabled"), disabled));
  return /*#__PURE__*/React.createElement("div", {
    className: classes
  }, indented && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--menu-option__icon")
  }, Icon && /*#__PURE__*/React.createElement(Icon, null)), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--menu-option__label"),
    title: label
  }, label), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--menu-option__info")
  }, info));
}

function MenuOption(_ref2) {
  var _classnames2;

  var children = _ref2.children,
      disabled = _ref2.disabled,
      indented = _ref2.indented,
      _ref2$kind = _ref2.kind,
      kind = _ref2$kind === void 0 ? 'default' : _ref2$kind,
      label = _ref2.label,
      level = _ref2.level,
      _ref2$onClick = _ref2.onClick,
      onClick = _ref2$onClick === void 0 ? function () {} : _ref2$onClick,
      renderIcon = _ref2.renderIcon,
      shortcut = _ref2.shortcut,
      rest = _objectWithoutProperties(_ref2, _excluded);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      submenuOpen = _useState2[0],
      setSubmenuOpen = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      submenuOpenedByKeyboard = _useState4[0],
      setSubmenuOpenedByKeyboard = _useState4[1];

  var rootRef = useRef(null);
  var hoverIntentTimeout = useRef(null);
  var subOptions = React.Children.map(children, function (node) {
    if ( /*#__PURE__*/React.isValidElement(node)) {
      return /*#__PURE__*/React.cloneElement(node);
    }
  });

  function openSubmenu() {
    var openedByKeyboard = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    setSubmenuOpenedByKeyboard(openedByKeyboard);
    setSubmenuOpen(true);
  }

  function handleKeyDown(event) {
    if (clickedElementHasSubnodes(event) && (match(event, keys.ArrowRight) || match(event, keys.Enter) || match(event, keys.Space))) {
      openSubmenu(true);
    } else if ((match(event, keys.Enter) || match(event, keys.Space)) && onClick) {
      onClick(event);
    }
  }

  function handleMouseEnter() {
    hoverIntentTimeout.current = setTimeout(openSubmenu, hoverIntentDelay);
  }

  function handleMouseLeave() {
    clearTimeout(hoverIntentTimeout === null || hoverIntentTimeout === void 0 ? void 0 : hoverIntentTimeout.current);
    setSubmenuOpen(false);
  }

  function getSubmenuPosition() {
    var pos = [0, 0];

    if (subOptions) {
      var parentMenu = getParentMenu(rootRef === null || rootRef === void 0 ? void 0 : rootRef.current);

      if (parentMenu) {
        var _parentMenu$getBoundi = parentMenu.getBoundingClientRect(),
            x = _parentMenu$getBoundi.x,
            width = _parentMenu$getBoundi.width;

        var _rootRef$current$getB = rootRef.current.getBoundingClientRect(),
            y = _rootRef$current$getB.y;

        pos[0] = x + width;
        pos[1] = y;
      }
    }

    return pos;
  }

  useEffect(function () {
    if (subOptions && submenuOpenedByKeyboard) {
      var firstSubnode = getFirstSubNode(rootRef === null || rootRef === void 0 ? void 0 : rootRef.current);
      focusNode(firstSubnode);
    } // eslint-disable-next-line react-hooks/exhaustive-deps

  }, [submenuOpen]);
  var classes = classnames("".concat(prefix, "--menu-option"), (_classnames2 = {}, _defineProperty(_classnames2, "".concat(prefix, "--menu-option--disabled"), disabled), _defineProperty(_classnames2, "".concat(prefix, "--menu-option--active"), subOptions && submenuOpen), _defineProperty(_classnames2, "".concat(prefix, "--menu-option--danger"), !subOptions && kind === 'danger'), _classnames2));
  var allowedRoles = ['menuitemradio', 'menuitemcheckbox'];
  var role = rest.role && allowedRoles.includes(rest.role) ? rest.role : 'menuitem';
  var submenuPosition = getSubmenuPosition();
  return (
    /*#__PURE__*/
    // role is either menuitemradio, menuitemcheckbox, or menuitem which are all interactive
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    React.createElement("li", _extends({}, rest, {
      ref: rootRef,
      className: classes,
      role: role,
      tabIndex: -1,
      "aria-disabled": !subOptions && disabled,
      "aria-haspopup": subOptions ? true : null,
      "aria-expanded": subOptions ? submenuOpen : null,
      onKeyDown: handleKeyDown,
      onMouseEnter: subOptions ? handleMouseEnter : null,
      onMouseLeave: subOptions ? handleMouseLeave : null,
      onClick: onClick
    }), subOptions ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(MenuOptionContent, {
      label: label,
      icon: renderIcon,
      info: /*#__PURE__*/React.createElement(CaretRight16, null),
      indented: indented
    }), /*#__PURE__*/React.createElement(Menu, {
      level: level + 1,
      open: submenuOpen,
      onClose: function onClose() {
        setSubmenuOpen(false);
      },
      x: submenuPosition[0],
      y: submenuPosition[1]
    }, subOptions)) : /*#__PURE__*/React.createElement(MenuOptionContent, {
      label: label,
      disabled: disabled,
      icon: renderIcon,
      info: shortcut,
      indented: indented
    }))
  );
}

MenuOptionContent.propTypes = {
  /**
   * Whether this option is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Icon that is displayed in front of the option
   */
  icon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Whether the content should be indented
   */
  indented: PropTypes.bool,

  /**
   * Additional information such as shortcut or caret
   */
  info: PropTypes.node,

  /**
   * Rendered label for the MenuOptionContent
   */
  label: PropTypes.node.isRequired
};
MenuOption.propTypes = {
  /**
   * Specify the children of the MenuOption
   */
  children: PropTypes.node,

  /**
   * Specify whether this MenuOption is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Whether the content should be indented (for example because it's in a group with options that have icons).
   * Is automatically set by Menu
   */
  indented: PropTypes.bool,

  /**
   * Optional prop to specify the kind of the MenuOption
   */
  kind: PropTypes.oneOf(['default', 'danger']),

  /**
   * Rendered label for the MenuOption
   */
  label: PropTypes.node.isRequired,

  /**
   * Which nested level this option is located in.
   * Is automatically set by Menu
   */
  level: PropTypes.number,

  /**
   * The onClick handler
   */
  onClick: PropTypes.func,

  /**
   * Rendered icon for the MenuOption.
   * Can be a React component class
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Rendered shortcut for the MenuOption
   */
  shortcut: PropTypes.node
};
export default MenuOption;