var _excluded = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded2 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded3 = ["listBoxMenuIconTranslationIds", "selectionFeedback"],
    _excluded4 = ["listBoxMenuIconTranslationIds", "selectionFeedback"];

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text, object } from '@storybook/addon-knobs';
import { withReadme } from 'storybook-readme';
import readme from './README.md';
import MultiSelect from '../MultiSelect';
import FilterableMultiSelect from '../MultiSelect/FilterableMultiSelect';
import Checkbox from '../Checkbox';
import mdx from './MultiSelect.mdx';
var items = [{
  id: 'downshift-1-item-0',
  text: 'Option 1'
}, {
  id: 'downshift-1-item-1',
  text: 'Option 2'
}, {
  id: 'downshift-1-item-2',
  text: 'Option 3'
}, {
  id: 'downshift-1-item-3',
  text: 'Option 4'
}, {
  id: 'downshift-1-item-4',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'downshift-1-item-5',
  text: 'Option 5'
}];
var defaultLabel = 'MultiSelect Label';
var defaultPlaceholder = 'Filter';
var types = {
  'Default (default)': 'default',
  'Inline (inline)': 'inline'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};

var props = function props() {
  return {
    id: text('MultiSelect ID (id)', 'carbon-multiselect-example'),
    titleText: text('Title (titleText)', 'Multiselect title'),
    helperText: text('Helper text (helperText)', 'This is helper text'),
    disabled: boolean('Disabled (disabled)', false),
    light: boolean('Light variant (light)', false),
    useTitleInItem: boolean('Show tooltip on hover', false),
    type: select('UI type (Only for `<MultiSelect>`) (type)', types, 'default'),
    size: select('Field size (size)', sizes, undefined) || undefined,
    direction: select('Dropdown direction (direction)', directions, 'bottom'),
    label: text('Label (label)', defaultLabel),
    invalid: boolean('Show form validation UI (invalid)', false),
    invalidText: text('Form validation UI content (invalidText)', 'Invalid Selection'),
    warn: boolean('Show warning state (warn)', false),
    warnText: text('Warning state text (warnText)', 'Selecting more items may increase processing time'),
    onChange: action('onChange'),
    onMenuChange: action('onMenuChange'),
    listBoxMenuIconTranslationIds: object('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu',
      'clear.all': 'Clear all',
      'clear.selection': 'Clear selection'
    }),
    selectionFeedback: select('Selection feedback', ['top', 'fixed', 'top-after-reopen'], 'top-after-reopen')
  };
};

export default {
  title: 'Components/MultiSelect',
  decorators: [withKnobs],
  parameters: {
    component: MultiSelect,
    docs: {
      page: mdx
    },
    subcomponents: {
      FilterableMultiSelect: FilterableMultiSelect
    }
  }
};
export var Default = withReadme(readme, function () {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      selectionFeedback = _props.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback
  })));
});
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: "\n        MultiSelect\n      "
  }
};
export var WithInitialSelectedItems = withReadme(readme, function () {
  var _props2 = props(),
      listBoxMenuIconTranslationIds = _props2.listBoxMenuIconTranslationIds,
      selectionFeedback = _props2.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props2, _excluded2);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    initialSelectedItems: [items[0], items[1]],
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback
  })));
});
WithInitialSelectedItems.storyName = 'with initial selected items';
WithInitialSelectedItems.parameters = {
  info: {
    text: "\n        Provide a set of items to initially select in the control\n      "
  }
};
export var _Filterable = withReadme(readme, function () {
  var _props3 = props(),
      listBoxMenuIconTranslationIds = _props3.listBoxMenuIconTranslationIds,
      selectionFeedback = _props3.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props3, _excluded3);

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(FilterableMultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: defaultPlaceholder,
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    onMenuChange: function onMenuChange(e) {
      multiSelectProps.onMenuChange(e);
    }
  })));
});
_Filterable.storyName = 'filterable';
_Filterable.parameters = {
  info: {
    text: "\n        When a list contains more than 25 items, use `MultiSelect.Filterable` to help find options from the list.\n      "
  }
};
export var WithChangeOnClose = withReadme(readme, function () {
  var _props4 = props(),
      listBoxMenuIconTranslationIds = _props4.listBoxMenuIconTranslationIds,
      selectionFeedback = _props4.selectionFeedback,
      multiSelectProps = _objectWithoutProperties(_props4, _excluded4);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      hasFocus = _useState2[0],
      setHasFocus = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      active = _useState4[0],
      setActive = _useState4[1];

  var _useState5 = useState([items[0]]),
      _useState6 = _slicedToArray(_useState5, 2),
      selItems = _useState6[0],
      setSelItems = _useState6[1];

  if (!hasFocus && active && selItems.length == 0) {
    setActive(false);
  }

  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/React.createElement(Checkbox, {
    id: "active",
    checked: active,
    onChange: function onChange(a) {
      setActive(a);

      if (a) {
        setSelItems([items[0]]);
      }
    },
    labelText: "Active"
  }), /*#__PURE__*/React.createElement(MultiSelect, _extends({}, multiSelectProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    },
    selectionFeedback: selectionFeedback,
    key: active,
    disabled: !active,
    initialSelectedItems: selItems,
    onMenuChange: function onMenuChange(e) {
      multiSelectProps.onMenuChange(e);
      setHasFocus(e);
    },
    onChange: function onChange(e) {
      setSelItems(e.selectedItems);
    }
  })));
});