var _excluded = ["numberInputArrowTranslationIds"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, text, object, select } from '@storybook/addon-knobs';
import NumberInput from '../NumberInput';
import { NumberInput as OGNumberInput } from './NumberInput';
import NumberInputSkeleton from '../NumberInput/NumberInput.Skeleton';
import mdx from './NumberInput.mdx';
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};

var props = function props() {
  return {
    className: 'some-class',
    id: 'tj-input',
    label: text('Label (label)', 'NumberInput label'),
    hideLabel: boolean('No label (hideLabel)', false),
    hideSteppers: boolean('No steppers (hideSteppers)', false),
    min: number('Minimum value (min)', 0),
    max: number('Maximum value (max)', 100),
    value: number('Value (value)', 50),
    step: number('Step of up/down arrow (step)', 10),
    size: select('Field size (size)', sizes, undefined) || undefined,
    disabled: boolean('Disabled (disabled)', false),
    readOnly: boolean('Read only (readOnly)', false),
    invalid: boolean('Show form validation UI (invalid)', false),
    invalidText: text('Form validation UI content (invalidText)', 'Number is not valid'),
    warn: boolean('Show warning state (warn)', false),
    warnText: text('Warning state text (warnText)', 'A high threshold may impact performance'),
    helperText: text('Helper text (helperText)', 'Optional helper text.'),
    light: boolean('Light variant (light)', false),
    onChange: action('onChange'),
    onClick: action('onClick'),
    allowEmpty: boolean('Allow empty value (allowEmpty)', false),
    numberInputArrowTranslationIds: object('Number input arrow icon translation IDs (for translateWithId callback)', {
      'increment.number': 'Increment number',
      'decrement.number': 'Decrement number'
    })
  };
};

export default {
  title: 'Components/NumberInput',
  component: OGNumberInput,
  decorators: [withKnobs],
  parameters: {
    docs: {
      page: mdx
    },
    subcomponents: {
      NumberInputSkeleton: NumberInputSkeleton
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(NumberInput, {
    id: "carbon-number",
    min: 0,
    max: 100,
    value: 50,
    label: "NumberInput label",
    helperText: "Optional helper text.",
    invalidText: "Number is not valid"
  });
};
Default.story = {
  name: 'Number Input'
};
export var Playground = function Playground() {
  var _props = props(),
      numberInputArrowTranslationIds = _props.numberInputArrowTranslationIds,
      rest = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/React.createElement(NumberInput, _extends({
    translateWithId: function translateWithId(id) {
      return numberInputArrowTranslationIds[id];
    }
  }, rest));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(NumberInputSkeleton, null);
};