function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from 'react';
import OrderedList from '../OrderedList';
import { withKnobs, boolean } from '@storybook/addon-knobs';
import ListItem from '../ListItem';
import mdx from './OrderedList.mdx';
var props = {
  regular: function regular() {
    return {
      isExpressive: boolean('Expressive', false)
    };
  }
};
export default {
  title: 'Components/OrderedList',
  decorators: [withKnobs],
  parameters: {
    component: OrderedList,
    docs: {
      page: mdx
    },
    subcomponents: {
      ListItem: ListItem
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(OrderedList, null, /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"));
};
Default.storyName = 'default';
Default.parameters = {
  info: {
    text: "Lists consist of related content grouped together and organized vertically. Ordered lists are used to present content in a numbered list."
  }
};
export var Nested = function Nested() {
  var regularProps = props.regular();
  return /*#__PURE__*/React.createElement(OrderedList, regularProps, /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1", /*#__PURE__*/React.createElement(OrderedList, {
    nested: true
  }, /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 2"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 2", /*#__PURE__*/React.createElement(OrderedList, {
    nested: true
  }, /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 3"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 3"))))), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"));
};
Nested.storyName = 'nested';
Nested.parameters = {
  info: {
    text: "Lists consist of related content grouped together and organized vertically. Ordered lists are used to present content in a numbered list."
  }
};
export var NativeListStyles = function NativeListStyles() {
  var regularProps = props.regular();
  return /*#__PURE__*/React.createElement(OrderedList, _extends({
    native: true
  }, regularProps), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1", /*#__PURE__*/React.createElement(OrderedList, {
    nested: true
  }, /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 2"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 2"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 2"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 2"))), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"), /*#__PURE__*/React.createElement(ListItem, null, "Ordered List level 1"));
};
Default.storyName = 'native styles';
NativeListStyles.parameters = {
  info: {
    text: "Lists consist of related content grouped together and organized vertically. Ordered lists are used to present content in a numbered list."
  }
};